/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;

public class EmptyLineSeparatorCheck
extends AbstractCheck {
    public static final String MSG_SHOULD_BE_SEPARATED = "empty.line.separator";
    public static final String MSG_MULTIPLE_LINES = "empty.line.separator.multiple.lines";
    public static final String MSG_MULTIPLE_LINES_AFTER = "empty.line.separator.multiple.lines.after";
    public static final String MSG_MULTIPLE_LINES_INSIDE = "empty.line.separator.multiple.lines.inside";
    private boolean allowNoEmptyLineBetweenFields;
    private boolean allowMultipleEmptyLines = true;
    private boolean allowMultipleEmptyLinesInsideClassMembers = true;

    public final void setAllowNoEmptyLineBetweenFields(boolean allow) {
        this.allowNoEmptyLineBetweenFields = allow;
    }

    public void setAllowMultipleEmptyLines(boolean allow) {
        this.allowMultipleEmptyLines = allow;
    }

    public void setAllowMultipleEmptyLinesInsideClassMembers(boolean allow) {
        this.allowMultipleEmptyLinesInsideClassMembers = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 14, 15, 154, 12, 11, 9, 8, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nextToken;
        if (this.hasMultipleLinesBefore(ast)) {
            this.log(ast.getLineNo(), MSG_MULTIPLE_LINES, ast.getText());
        }
        if (!this.allowMultipleEmptyLinesInsideClassMembers) {
            this.processMultipleLinesInside(ast);
        }
        if ((nextToken = ast.getNextSibling()) != null) {
            int astType = ast.getType();
            switch (astType) {
                case 10: {
                    this.processVariableDef(ast, nextToken);
                    break;
                }
                case 30: {
                    this.processImport(ast, nextToken, astType);
                    break;
                }
                case 16: {
                    this.processPackage(ast, nextToken);
                    break;
                }
                default: {
                    if (nextToken.getType() == 73) {
                        if (!this.hasNotAllowedTwoEmptyLinesBefore(nextToken)) break;
                        this.log(ast.getLineNo(), MSG_MULTIPLE_LINES_AFTER, ast.getText());
                        break;
                    }
                    if (this.hasEmptyLineAfter(ast)) break;
                    this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
                }
            }
        }
    }

    private void processMultipleLinesInside(DetailAST ast) {
        int astType = ast.getType();
        if (EmptyLineSeparatorCheck.isClassMemberBlock(astType)) {
            List<Integer> emptyLines = this.getEmptyLines(ast);
            List<Integer> emptyLinesToLog = EmptyLineSeparatorCheck.getEmptyLinesToLog(emptyLines);
            for (Integer lineNo : emptyLinesToLog) {
                this.log(lineNo + 1, MSG_MULTIPLE_LINES_INSIDE, new Object[0]);
            }
        }
    }

    private static boolean isClassMemberBlock(int astType) {
        return astType == 12 || astType == 11 || astType == 9 || astType == 8;
    }

    private List<Integer> getEmptyLines(DetailAST ast) {
        DetailAST lastToken = ast.getLastChild().getLastChild();
        int lastTokenLineNo = 0;
        if (lastToken != null) {
            lastTokenLineNo = lastToken.getLineNo();
        }
        ArrayList<Integer> emptyLines = new ArrayList<Integer>();
        FileContents fileContents = this.getFileContents();
        for (int lineNo = ast.getLineNo(); lineNo < lastTokenLineNo; ++lineNo) {
            if (!fileContents.lineIsBlank(lineNo)) continue;
            emptyLines.add(lineNo);
        }
        return emptyLines;
    }

    private static List<Integer> getEmptyLinesToLog(List<Integer> emptyLines) {
        ArrayList<Integer> emptyLinesToLog = new ArrayList<Integer>();
        if (emptyLines.size() > 1) {
            int previousEmptyLineNo = emptyLines.get(0);
            for (int emptyLineNo : emptyLines) {
                if (previousEmptyLineNo + 1 == emptyLineNo) {
                    emptyLinesToLog.add(emptyLineNo);
                }
                previousEmptyLineNo = emptyLineNo;
            }
        }
        return emptyLinesToLog;
    }

    private boolean hasMultipleLinesBefore(DetailAST ast) {
        boolean result = false;
        if ((ast.getType() != 10 || EmptyLineSeparatorCheck.isTypeField(ast)) && this.hasNotAllowedTwoEmptyLinesBefore(ast)) {
            result = true;
        }
        return result;
    }

    private void processPackage(DetailAST ast, DetailAST nextToken) {
        if (ast.getLineNo() > 1 && !this.hasEmptyLineBefore(ast)) {
            this.log(ast.getLineNo(), MSG_SHOULD_BE_SEPARATED, ast.getText());
        }
        if (!this.hasEmptyLineAfter(ast)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private void processImport(DetailAST ast, DetailAST nextToken, int astType) {
        if (astType != nextToken.getType() && !this.hasEmptyLineAfter(ast)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private void processVariableDef(DetailAST ast, DetailAST nextToken) {
        if (EmptyLineSeparatorCheck.isTypeField(ast) && !this.hasEmptyLineAfter(ast) && this.isViolatingEmptyLineBetweenFieldsPolicy(nextToken)) {
            this.log(nextToken.getLineNo(), MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private boolean isViolatingEmptyLineBetweenFieldsPolicy(DetailAST detailAST) {
        return this.allowNoEmptyLineBetweenFields && detailAST.getType() != 10 && detailAST.getType() != 73 || !this.allowNoEmptyLineBetweenFields && detailAST.getType() != 73;
    }

    private boolean hasNotAllowedTwoEmptyLinesBefore(DetailAST token) {
        return !this.allowMultipleEmptyLines && this.hasEmptyLineBefore(token) && this.isPrePreviousLineEmpty(token);
    }

    private boolean isPrePreviousLineEmpty(DetailAST token) {
        boolean result = false;
        int lineNo = token.getLineNo();
        int number = 3;
        if (lineNo >= 3) {
            String prePreviousLine = this.getLines()[lineNo - 3];
            result = prePreviousLine.trim().isEmpty();
        }
        return result;
    }

    private boolean hasEmptyLineAfter(DetailAST token) {
        DetailAST lastToken = token.getLastChild().getLastChild();
        if (lastToken == null) {
            lastToken = token.getLastChild();
        }
        int nextBegin = token.getNextSibling().getLineNo();
        int currentEnd = lastToken.getLineNo();
        return this.hasEmptyLine(currentEnd + 1, nextBegin - 1);
    }

    private boolean hasEmptyLine(int startLine, int endLine) {
        boolean result = false;
        if (startLine <= endLine) {
            FileContents fileContents = this.getFileContents();
            for (int line = startLine; line <= endLine; ++line) {
                if (!fileContents.lineIsBlank(line - 1)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean hasEmptyLineBefore(DetailAST token) {
        int lineNo = token.getLineNo();
        if (lineNo == 1) {
            return false;
        }
        String lineBefore = this.getLines()[lineNo - 2];
        return lineBefore.trim().isEmpty();
    }

    private static boolean isTypeField(DetailAST variableDef) {
        int parentType = variableDef.getParent().getParent().getType();
        return parentType == 14;
    }
}

