/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.checks.header.HeaderViolationMonitor;
import com.puppycrawl.tools.checkstyle.checks.header.RegexpHeaderInfo;
import java.util.Arrays;
import java.util.regex.Pattern;

class RegexpHeaderChecker {
    private final String[] mHeaderLines;
    private Pattern[] mHeaderRegexps;
    private int[] mMultiLines;
    private final HeaderViolationMonitor mViolationObserver;

    RegexpHeaderChecker(RegexpHeaderInfo aRegexpHeaderInfo, HeaderViolationMonitor aViolationObserver) {
        this.mHeaderLines = aRegexpHeaderInfo.getHeaderLines();
        this.mHeaderRegexps = aRegexpHeaderInfo.geHeaderRegexps();
        this.mMultiLines = aRegexpHeaderInfo.getMultLines();
        this.mViolationObserver = aViolationObserver;
    }

    void checkLines(String[] aLines) {
        int headerSize = this.mHeaderLines.length;
        int fileSize = aLines.length;
        if (headerSize - this.mMultiLines.length > fileSize) {
            this.mViolationObserver.reportHeaderMissing();
        } else {
            int i;
            int headerLineNo = 0;
            for (i = 0; headerLineNo < headerSize && i < fileSize; ++i) {
                String line = aLines[i];
                boolean isMatch = this.isMatch(line, headerLineNo);
                while (!isMatch && this.isMultiLine(headerLineNo)) {
                    isMatch = ++headerLineNo == headerSize || this.isMatch(line, headerLineNo);
                }
                if (!isMatch) {
                    this.mViolationObserver.reportHeaderMismatch(i + 1, this.mHeaderLines[headerLineNo]);
                    break;
                }
                if (this.isMultiLine(headerLineNo)) continue;
                ++headerLineNo;
            }
            if (i == fileSize) {
                while (headerLineNo < headerSize) {
                    if (!this.isMultiLine(headerLineNo)) {
                        this.mViolationObserver.reportHeaderMissing();
                        break;
                    }
                    ++headerLineNo;
                }
            }
        }
    }

    private boolean isMatch(String aLine, int aHeaderLineNo) {
        return this.mHeaderRegexps[aHeaderLineNo].matcher(aLine).find();
    }

    private boolean isMultiLine(int aLineNo) {
        return Arrays.binarySearch(this.mMultiLines, aLineNo + 1) >= 0;
    }
}

