/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;

public final class CheckDocsDoclet {
    private static final String DEST_DIR_OPT = "-d";

    private static String getDescription(ClassDoc aClassDoc) {
        Tag[] tags = aClassDoc.firstSentenceTags();
        StringBuffer buf = new StringBuffer();
        if (tags.length > 0) {
            buf.append(tags[0].text());
        }
        CheckDocsDoclet.removeOpeningParagraphTag(buf);
        return buf.toString();
    }

    private static void removeOpeningParagraphTag(StringBuffer aText) {
        String openTag = "<p>";
        int tagLen = "<p>".length();
        if (aText.length() > tagLen && aText.substring(0, tagLen).equals("<p>")) {
            aText.delete(0, tagLen);
        }
    }

    private static String getCheckName(ClassDoc aClassDoc) {
        String strippedClassName = aClassDoc.typeName();
        String checkName = strippedClassName.endsWith("Check") ? strippedClassName.substring(0, strippedClassName.length() - "Check".length()) : strippedClassName;
        return checkName;
    }

    private static void writeXdocsHeader(PrintWriter aPrintWriter, String aTitle) {
        aPrintWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        aPrintWriter.println("<document>");
        aPrintWriter.println("<properties>");
        aPrintWriter.println("<title>" + aTitle + "</title>");
        aPrintWriter.println("<author email=\"checkstyle-devel@lists.sourceforge.net\">Checkstyle Development Team</author>");
        aPrintWriter.println("</properties>");
        aPrintWriter.println("<body>");
        aPrintWriter.flush();
    }

    private static void writeXdocsFooter(PrintWriter aPrintWriter) {
        aPrintWriter.println("</body>");
        aPrintWriter.println("</document>");
        aPrintWriter.flush();
    }

    public static boolean start(RootDoc aRoot) throws IOException {
        ClassDoc[] classDocs = aRoot.classes();
        File destDir = new File(CheckDocsDoclet.getDestDir(aRoot.options()));
        File checksIndexFile = new File(destDir, "availablechecks.xml");
        PrintWriter fileWriter = new PrintWriter(new FileWriter(checksIndexFile));
        CheckDocsDoclet.writeXdocsHeader(fileWriter, "Available Checks");
        fileWriter.println("<p>Checkstyle provides many checks that you can apply to your sourcecode. Below is an alphabetical reference, the site navigation menu provides a reference organized by functionality.</p>");
        fileWriter.println("<table>");
        Arrays.sort(classDocs, new ClassDocByCheckNameComparator());
        for (int i = 0; i < classDocs.length; ++i) {
            ClassDoc classDoc = classDocs[i];
            if (!classDoc.typeName().endsWith("Check") || classDoc.isAbstract()) continue;
            String pageName = CheckDocsDoclet.getPageName(classDoc);
            Tag[] docPageTags = classDoc.tags("checkstyle-docpage");
            if (docPageTags != null && docPageTags.length > 0) {
                pageName = docPageTags[0].text();
            }
            String descr = CheckDocsDoclet.getDescription(classDoc);
            String checkName = CheckDocsDoclet.getCheckName(classDoc);
            fileWriter.println("<tr><td><a href=\"config_" + pageName + ".html#" + checkName + "\">" + checkName + "</a></td><td>" + descr + "</td></tr>");
        }
        fileWriter.println("</table>");
        CheckDocsDoclet.writeXdocsFooter(fileWriter);
        fileWriter.close();
        return true;
    }

    private static String getPageName(ClassDoc aClassDoc) {
        String packageName = aClassDoc.containingPackage().name();
        String pageName = packageName.substring(packageName.lastIndexOf(46) + 1);
        if ("checks".equals(pageName)) {
            return "misc";
        }
        return pageName;
    }

    public static String getDestDir(String[][] aOptions) {
        for (int i = 0; i < aOptions.length; ++i) {
            String[] opt = aOptions[i];
            if (!DEST_DIR_OPT.equalsIgnoreCase(opt[0])) continue;
            return opt[1];
        }
        return null;
    }

    public static int optionLength(String aOption) {
        if (DEST_DIR_OPT.equals(aOption)) {
            return 2;
        }
        return 0;
    }

    private static class ClassDocByCheckNameComparator
    implements Comparator {
        private ClassDocByCheckNameComparator() {
        }

        public int compare(Object aObject1, Object aObject2) {
            ClassDoc classDoc1 = (ClassDoc)aObject1;
            ClassDoc classDoc2 = (ClassDoc)aObject2;
            String checkName1 = CheckDocsDoclet.getCheckName(classDoc1);
            String checkName2 = CheckDocsDoclet.getCheckName(classDoc2);
            return checkName1.compareTo(checkName2);
        }
    }
}

