#
# ovirt-hosted-engine-ha -- ovirt hosted engine high availability
# Copyright (C) 2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

"""Constants."""

PACKAGE_NAME = 'ovirt-hosted-engine-ha'
PROGRAM_NAME = 'agent'
PACKAGE_VERSION = '1.2.7.1'
FULL_PROG_NAME = '{0} {1} {2}'.format(
                 PACKAGE_NAME, PROGRAM_NAME, PACKAGE_VERSION)

# Metadata can be parsed by agents as old as METADATA_PARSE_VERSION, but may
# contain new/additional information as new as METADATA_FEATURE_VERSION.  This
# allows detection of enhancements without breaking backwards compatibility.
#
# Note: The range of valid metadata versions for this host is from
# METADATA_PARSE_VERSION <= version <= METADATA_FEATURE_VERSION.  If an
# incompatible change is made to the metadata, both the parse and feature
# versions should be raised beyond the current feature version.  This will
# ensure that a) the old agent will recognize that it has been superseded
# and shut down the vm, and b) the newer agents will ignore the older agents'
# reported scores, thus assuming control of the vm.
METADATA_PARSE_VERSION = 1
METADATA_FEATURE_VERSION = 1

METADATA_BLOCK_BYTES = 512
SERVICE_TYPE = 'hosted-engine'
MD_EXTENSION = '.metadata'
LOCKSPACE_EXTENSION = '.lockspace'
BROKER_CONNECTION_RETRIES = 10
BROKER_CONNECTION_WAIT = 5
HOST_ALIVE_TIMEOUT_SECS = 60
ENGINE_RETRY_EXPIRATION_SECS = 600
ENGINE_RETRY_MAX_ATTEMPTS = 3
ENGINE_BAD_HEALTH_TIMEOUT_SECS = 300
ENGINE_BAD_HEALTH_EXPIRATION_SECS = 600
VM_UNEXPECTED_SHUTDOWN_EXPIRATION_SECS = 600
MAX_VDSM_WAIT_SECS = 15
MAX_VDSM_START_RETRIES = 5
MAX_DOMAIN_MONITOR_WAIT_SECS = 240
METADATA_LOG_PERIOD_SECS = 600
ENGINE_STARTING_TIMEOUT = 600
AGENT_START_RETRIES = 10
AGENT_START_RETRY_WAIT = 5

BASE_SCORE = 2400
GATEWAY_SCORE_PENALTY = 1600
MGMT_BRIDGE_SCORE_PENALTY = 600
FREE_MEMORY_SCORE_PENALTY = 400
CPU_LOAD_SCORE_PENALTY = 1000
ENGINE_RETRY_SCORE_PENALTY = 50

CPU_LOAD_PENALTY_MIN = 0.4
CPU_LOAD_PENALTY_MAX = 0.9

VDSM_USER = 'vdsm'
VDSM_GROUP = 'kvm'

# See http://www.gnu.org/software/automake/manual/html_node/Scripts.html
LOG_CONF_FILE = '/etc/ovirt-hosted-engine-ha/agent-log.conf'
LOG_FILE = '/var/log/ovirt-hosted-engine-ha/agent.log'
PID_FILE = '/var/run/ovirt-hosted-engine-ha/agent.pid'

AGENT_CONF_FILE = '/etc/ovirt-hosted-engine-ha/agent.conf'
ENGINE_SETUP_CONF_FILE = '/etc/ovirt-hosted-engine/hosted-engine.conf'
VM_CONF_FILE = '/etc/ovirt-hosted-engine/vm.conf'

VDSM_CERT_FILE = '/etc/pki/vdsm/certs/vdsmcert.pem'

HOSTED_ENGINE_BINARY = '/usr/sbin/hosted-engine'

SD_MOUNT_PARENT = '/rhev/data-center/mnt'
SD_METADATA_DIR = 'ha_agent'
LOCKSPACE_NAME = SERVICE_TYPE

# Maximum request error count
MAX_ERROR_COUNT = 3

# The length of history
STATS_HISTORY_SECS = 15 * 60

WAIT_FOR_STORAGE_RETRY = 5
WAIT_FOR_STORAGE_DELAY = 5
