/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.JmsSession;
import org.jboss.resource.adapter.jms.JmsSessionFactory;
import org.jboss.resource.adapter.jms.util.JMSProducerUtils;

public class GenericJmsContext
implements JMSContext {
    private static final Logger log = Logger.getLogger(GenericJmsContext.class);
    private static final String ILLEGAL_METHOD = "This method is not applicable inside the application server. See the JEE spec, e.g. JEE 7 Section 6.7";
    private final JmsSessionFactory sessionFactory;
    private final JmsSession session;
    private final Set<JMSProducer> producers = Collections.synchronizedSet(new HashSet());

    GenericJmsContext(JmsSessionFactory sessionFactory, JmsSession session) {
        this.sessionFactory = sessionFactory;
        this.session = session;
    }

    public JMSContext createContext(int sessionMode) {
        throw new JMSRuntimeException(ILLEGAL_METHOD);
    }

    public JMSProducer createProducer() {
        JMSProducer producer = this.session.getJMSContext().createProducer();
        this.producers.add(producer);
        return producer;
    }

    public String getClientID() {
        return this.session.getJMSContext().getClientID();
    }

    public void setClientID(String clientID) {
        throw new JMSRuntimeException(ILLEGAL_METHOD);
    }

    public ConnectionMetaData getMetaData() {
        return this.session.getJMSContext().getMetaData();
    }

    public ExceptionListener getExceptionListener() {
        return this.session.getJMSContext().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) {
        throw new JMSRuntimeException(ILLEGAL_METHOD);
    }

    public void start() {
        this.session.getJMSContext().start();
    }

    public void stop() {
        throw new JMSRuntimeException(ILLEGAL_METHOD);
    }

    public void setAutoStart(boolean autoStart) {
        this.session.getJMSContext().setAutoStart(autoStart);
    }

    public boolean getAutoStart() {
        return this.session.getJMSContext().getAutoStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Set<JMSProducer> set = this.producers;
            synchronized (set) {
                for (JMSProducer producer : this.producers) {
                    if (producer == null) continue;
                    try {
                        JMSProducerUtils.close(producer);
                    }
                    catch (PrivilegedActionException ex) {
                        throw (JMSException)((Object)ex.getException());
                    }
                }
                this.producers.clear();
            }
            this.session.close();
            this.sessionFactory.close();
        }
        catch (JMSException e) {
            log.debugf((Throwable)e, "Error closing the JMSContext", new Object[0]);
        }
    }

    public BytesMessage createBytesMessage() {
        return this.session.getJMSContext().createBytesMessage();
    }

    public MapMessage createMapMessage() {
        return this.session.getJMSContext().createMapMessage();
    }

    public Message createMessage() {
        return this.session.getJMSContext().createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.session.getJMSContext().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.session.getJMSContext().createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() {
        return this.session.getJMSContext().createStreamMessage();
    }

    public TextMessage createTextMessage() {
        return this.session.getJMSContext().createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.session.getJMSContext().createTextMessage(text);
    }

    public boolean getTransacted() {
        return this.session.getJMSContext().getTransacted();
    }

    public int getSessionMode() {
        return this.session.getJMSContext().getSessionMode();
    }

    public void commit() {
        this.session.getJMSContext().commit();
    }

    public void rollback() {
        this.session.getJMSContext().rollback();
    }

    public void recover() {
        this.session.getJMSContext().recover();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.session.getJMSContext().createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.session.getJMSContext().createConsumer(destination, messageSelector);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return this.session.getJMSContext().createConsumer(destination, messageSelector, noLocal);
    }

    public Queue createQueue(String queueName) {
        return this.session.getJMSContext().createQueue(queueName);
    }

    public Topic createTopic(String topicName) {
        return this.session.getJMSContext().createTopic(topicName);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.session.getJMSContext().createDurableConsumer(topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return this.session.getJMSContext().createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.session.getJMSContext().createSharedDurableConsumer(topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return this.session.getJMSContext().createSharedDurableConsumer(topic, name, messageSelector);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.session.getJMSContext().createSharedConsumer(topic, sharedSubscriptionName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return this.session.getJMSContext().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.session.getJMSContext().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.session.getJMSContext().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.session.getJMSContext().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.session.getJMSContext().createTemporaryTopic();
    }

    public void unsubscribe(String name) {
        this.session.getJMSContext().unsubscribe(name);
    }

    public void acknowledge() {
        this.session.getJMSContext().acknowledge();
    }
}

