/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import java.util.Objects;

public class HttpClientRequestImpl
extends HttpClientRequestBase
implements HttpClientRequest {
    static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    private final Promise<Void> endPromise = this.context.promise();
    private final Future<Void> endFuture = this.endPromise.future();
    private boolean chunked = false;
    private Handler<Void> continueHandler;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean ended;
    private Throwable reset;
    private int followRedirects;
    private HeadersMultiMap headers;
    private StreamPriority priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
    private boolean headWritten;
    private boolean isConnect;

    HttpClientRequestImpl(HttpClientImpl client, HttpClientStream stream, PromiseInternal<HttpClientResponse> responsePromise, boolean ssl, HttpMethod method, SocketAddress server, String host, int port, String requestURI) {
        super(client, stream, responsePromise, ssl, method, server, host, port, requestURI);
        stream.continueHandler(this::handleContinue);
        stream.drainHandler(this::handleDrained);
        stream.exceptionHandler(this::handleException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleException(Throwable t) {
        Handler<Throwable> handler;
        super.handleException(t);
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.exceptionHandler;
            if (handler == null || this.endFuture.isComplete()) {
                log.error(t);
                return;
            }
        }
        this.context.emit(t, handler);
        this.endPromise.tryFail(t);
    }

    @Override
    public synchronized HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.checkEnded();
        this.followRedirects = followRedirects ? this.client.getOptions().getMaxRedirects() - 1 : 0;
        return this;
    }

    @Override
    public synchronized HttpClientRequest setMaxRedirects(int maxRedirects) {
        Arguments.require(maxRedirects >= 0, "Max redirects must be >= 0");
        this.checkEnded();
        this.followRedirects = maxRedirects;
        return this;
    }

    @Override
    public synchronized HttpClientRequestImpl setChunked(boolean chunked) {
        this.checkEnded();
        if (this.headWritten) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        if (this.client.getOptions().getProtocolVersion() != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = HeadersMultiMap.httpHeaders();
        }
        return this.headers;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, String value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.checkEnded();
        this.stream.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
        }
        return this.stream.isNotWritable();
    }

    @Override
    public HttpVersion version() {
        return this.stream.version();
    }

    private synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkEnded();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    @Override
    public synchronized HttpClientRequest drainHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.checkEnded();
        this.drainHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpClientRequest continueHandler(Handler<Void> handler) {
        if (handler != null) {
            this.checkEnded();
        }
        this.continueHandler = handler;
        return this;
    }

    @Override
    public Future<Void> sendHead() {
        PromiseInternal<Void> promise = this.context.promise();
        this.sendHead(promise);
        return promise.future();
    }

    @Override
    public HttpClientRequest sendHead(Handler<AsyncResult<Void>> headersHandler) {
        this.checkEnded();
        this.doWrite(null, false, false, headersHandler);
        return this;
    }

    @Override
    public Future<HttpClientResponse> connect() {
        if (this.client.getOptions().isPipelining()) {
            return this.context.failedFuture("Cannot upgrade a pipe-lined request");
        }
        this.doWrite(null, false, true, ar -> {});
        return this.response();
    }

    @Override
    public void connect(Handler<AsyncResult<HttpClientResponse>> handler) {
        Future<HttpClientResponse> fut = this.connect();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.checkEnded();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkEnded();
        this.headers().set(name, values);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean reset(Throwable cause) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.reset != null) {
                return false;
            }
            this.reset = cause;
        }
        this.stream.reset(cause);
        return true;
    }

    private void tryComplete() {
        this.endPromise.tryComplete();
    }

    @Override
    public synchronized HttpConnection connection() {
        return this.stream.connection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            this.checkEnded();
        }
        this.stream.writeFrame(type, flags, payload.getByteBuf());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDrained(Void v) {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.drainHandler;
            if (handler == null || this.endFuture.isComplete()) {
                return;
            }
        }
        this.context.dispatch(handler);
    }

    private void handleNextRequest(HttpClientRequest next, Handler<AsyncResult<HttpClientResponse>> handler, long timeoutMs) {
        next.response(handler);
        next.exceptionHandler((Handler)this.exceptionHandler());
        this.exceptionHandler((Handler)null);
        next.pushHandler(this.pushHandler());
        next.setMaxRedirects(this.followRedirects - 1);
        if (this.headers != null) {
            next.headers().addAll(this.headers);
        }
        this.endFuture.onComplete(ar -> {
            if (ar.succeeded()) {
                if (timeoutMs > 0L) {
                    next.setTimeout(timeoutMs);
                }
                next.end();
            } else {
                next.reset(0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContinue(Void v) {
        Handler<Void> handler;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            handler = this.continueHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    @Override
    void handleResponse(Promise<HttpClientResponse> promise, HttpClientResponse resp, long timeoutMs) {
        Future<RequestOptions> next;
        if (this.reset != null) {
            return;
        }
        int statusCode = resp.statusCode();
        if (this.followRedirects > 0 && statusCode >= 300 && statusCode < 400 && (next = this.client.redirectHandler().apply(resp)) != null) {
            next.onComplete(ar1 -> {
                if (ar1.succeeded()) {
                    RequestOptions options = (RequestOptions)ar1.result();
                    Future<HttpClientRequest> f = this.client.request(options);
                    f.onComplete(ar2 -> {
                        if (ar2.succeeded()) {
                            this.handleNextRequest((HttpClientRequest)ar2.result(), promise, timeoutMs);
                        } else {
                            this.fail(ar2.cause());
                        }
                    });
                } else {
                    this.fail(ar1.cause());
                }
            });
            return;
        }
        promise.complete(resp);
    }

    @Override
    public Future<Void> end(String chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.end(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        PromiseInternal<Void> promise = this.context.promise();
        this.end(chunk, enc, promise);
        return promise.future();
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.end(Buffer.buffer(chunk, enc), handler);
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk.getByteBuf(), true, promise);
        return promise.future();
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk.getByteBuf(), true, handler);
    }

    @Override
    public Future<Void> end() {
        PromiseInternal<Void> promise = this.context.promise();
        this.end((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.write(null, true, handler);
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, handler);
    }

    @Override
    public Future<Void> write(String chunk) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk).getByteBuf(), false, handler);
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        PromiseInternal<Void> promise = this.context.promise();
        this.write(chunk, enc, promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        Objects.requireNonNull(enc, "no null encoding accepted");
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, handler);
    }

    private boolean requiresContentLength() {
        return !this.chunked && (this.headers == null || !this.headers.contains(HttpHeaders.CONTENT_LENGTH)) && !this.isConnect;
    }

    private void write(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> completionHandler) {
        if (end) {
            if (buff != null && this.requiresContentLength()) {
                this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buff.readableBytes()));
            }
        } else if (this.requiresContentLength()) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        this.doWrite(buff, end, false, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(ByteBuf buff, boolean end, boolean connect, Handler<AsyncResult<Void>> completionHandler) {
        boolean writeHead;
        HttpClientRequestImpl httpClientRequestImpl = this;
        synchronized (httpClientRequestImpl) {
            if (this.ended) {
                completionHandler.handle(Future.failedFuture(new IllegalStateException("Request already complete")));
                return;
            }
            this.checkResponseHandler();
            if (!this.headWritten) {
                this.headWritten = true;
                this.isConnect = connect;
                writeHead = true;
            } else {
                writeHead = false;
            }
            this.ended = end;
        }
        if (writeHead) {
            HttpMethod method = this.getMethod();
            String uri = this.getURI();
            HttpRequestHead head = new HttpRequestHead(method, uri, this.headers, this.authority(), this.absoluteURI());
            this.stream.writeHead(head, this.chunked, buff, this.ended, this.priority, connect, completionHandler);
        } else {
            if (buff == null && !end) {
                throw new IllegalArgumentException();
            }
            this.stream.writeBuffer(buff, end, completionHandler);
        }
        if (end) {
            this.tryComplete();
        }
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkResponseHandler() {
    }

    @Override
    public synchronized HttpClientRequest setStreamPriority(StreamPriority priority) {
        if (this.headWritten) {
            this.stream.updatePriority(priority);
        } else {
            this.priority = priority;
        }
        return this;
    }

    @Override
    public synchronized StreamPriority getStreamPriority() {
        return this.stream.priority();
    }
}

