/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Supplier;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.util.AbstractCollectionMarshaller;

public class CollectionMarshaller<T extends Collection<Object>>
extends AbstractCollectionMarshaller<T> {
    private final Supplier<T> factory;

    public CollectionMarshaller(Supplier<T> factory) {
        super(((Collection)factory.get()).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Collection collection = (Collection)this.factory.get();
        boolean reading = true;
        block3: while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    collection.add(reader.readObject(Any.class).get());
                    continue block3;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return (T)collection;
    }
}

