/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.model.basic;

import org.picketlink.idm.model.AbstractIdentityType;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.model.annotation.IdentityStereotype;
import org.picketlink.idm.model.annotation.InheritsPrivileges;
import org.picketlink.idm.model.annotation.StereotypeProperty;
import org.picketlink.idm.model.annotation.Unique;
import org.picketlink.idm.query.QueryParameter;

@IdentityStereotype(value=IdentityStereotype.Stereotype.GROUP)
public class Group
extends AbstractIdentityType {
    private static final long serialVersionUID = -3553832607918448916L;
    public static final QueryParameter NAME = AttributedType.QUERY_ATTRIBUTE.byName("name");
    public static final QueryParameter PATH = AttributedType.QUERY_ATTRIBUTE.byName("path");
    public static final QueryParameter PARENT = AttributedType.QUERY_ATTRIBUTE.byName("parentGroup");
    public static final String PATH_SEPARATOR = "/";
    private String name;
    private Group parentGroup;
    private String path;

    public Group() {
    }

    public Group(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Error creating Group - name cannot be null or empty");
        }
        this.name = name;
        this.path = this.buildPath(this);
    }

    public Group(String name, Group parentGroup) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Error creating Group - name cannot be null or empty");
        }
        this.name = name;
        this.parentGroup = parentGroup;
        this.path = this.buildPath(this);
    }

    @AttributeProperty
    @StereotypeProperty(value=StereotypeProperty.Property.IDENTITY_GROUP_NAME)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @AttributeProperty
    @Unique
    public String getPath() {
        this.path = this.buildPath(this);
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @InheritsPrivileges
    @AttributeProperty
    public Group getParentGroup() {
        return this.parentGroup;
    }

    @AttributeProperty
    public void setParentGroup(Group group) {
        this.parentGroup = group;
    }

    private String buildPath(Group group) {
        String name = PATH_SEPARATOR + group.getName();
        if (group.getParentGroup() != null) {
            name = this.buildPath(group.getParentGroup()) + name;
        }
        return name;
    }
}

