/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    public static void setThreadContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
    }

    static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    static int hashCode(final Subject subject) {
        if (System.getSecurityManager() == null) {
            return subject.hashCode();
        }
        Integer hashCode = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return subject.hashCode();
            }
        });
        return hashCode;
    }

    static boolean equals(final Subject s1, final Subject s2) {
        if (System.getSecurityManager() == null) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
        Boolean equals = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return s1 != null ? s1.equals(s2) : s2 == null;
            }
        });
        return equals;
    }
}

