/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private static final String STATE_PRIMARY_OWNERS = "primaryOwners.%d";
    private static final String STATE_PRIMARY_OWNERS_COUNT = "primaryOwners";
    private final int[] primaryOwners;
    private final List<Address> members;
    private final Set<Address> membersSet;
    private final Set<Integer> segments;

    public ReplicatedConsistentHash(List<Address> members, int[] primaryOwners) {
        this.members = Collections.unmodifiableList(new ArrayList<Address>(members));
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(members));
        this.primaryOwners = primaryOwners;
        this.segments = IntSets.immutableRangeSet((int)primaryOwners.length);
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch2) {
        if (this.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.getMembers());
        for (Address member : ch2.getMembers()) {
            if (unionMembers.contains(member)) continue;
            unionMembers.add(member);
        }
        int[] primaryOwners = new int[this.getNumSegments()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
        }
        return new ReplicatedConsistentHash(unionMembers, primaryOwners);
    }

    ReplicatedConsistentHash(ScopedPersistentState state) {
        int numMembers = Integer.parseInt(state.getProperty("members"));
        this.members = new ArrayList<Address>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format("member.%d", i)));
            this.members.add(uuid);
        }
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(this.members));
        int numPrimaryOwners = state.getIntProperty(STATE_PRIMARY_OWNERS_COUNT);
        this.primaryOwners = new int[numPrimaryOwners];
        for (int i = 0; i < numPrimaryOwners; ++i) {
            this.primaryOwners[i] = state.getIntProperty(String.format(STATE_PRIMARY_OWNERS, i));
        }
        this.segments = IntSets.immutableRangeSet((int)this.primaryOwners.length);
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.length;
    }

    public int getNumOwners() {
        return this.members.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.members.size());
        owners.add(primaryOwner);
        for (Address member : this.members) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners[segmentId]);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.membersSet.contains(owner)) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        return this.segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        IntSet primarySegments = IntSets.mutableEmptySet((int)this.primaryOwners.length);
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (this.primaryOwners[i] != index) continue;
            primarySegments.set(i);
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (Address a : this.members) {
            if (sb.length() > 0) {
                sb.append("\n  ");
            }
            Set<Integer> primarySegments = this.getPrimarySegmentsForOwner(a);
            sb.append(a).append(" primary: ").append(primarySegments);
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.membersSet.contains(nodeAddress);
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        int i;
        state.setProperty("consistentHash", this.getClass().getName());
        state.setProperty("members", Integer.toString(this.members.size()));
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("member.%d", i), this.members.get(i).toString());
        }
        state.setProperty(STATE_PRIMARY_OWNERS_COUNT, Integer.toString(this.primaryOwners.length));
        for (i = 0; i < this.primaryOwners.length; ++i) {
            state.setProperty(String.format(STATE_PRIMARY_OWNERS, i), Integer.toString(this.primaryOwners[i]));
        }
    }

    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        ArrayList<Address> remappedMembers = new ArrayList<Address>(this.members.size());
        Iterator<Address> i = this.members.iterator();
        while (i.hasNext()) {
            Address a = (Address)remapper.apply(i.next());
            if (a == null) {
                return null;
            }
            remappedMembers.add(a);
        }
        return new ReplicatedConsistentHash(remappedMembers, this.primaryOwners);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.segments.size());
        sb.append(", owners = (").append(this.members.size()).append(")[");
        int[] primaryOwned = new int[this.members.size()];
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            int n = this.primaryOwners[i];
            primaryOwned[n] = primaryOwned[n] + 1;
        }
        boolean first = true;
        for (int i = 0; i < this.members.size(); ++i) {
            Address a = this.members.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(a).append(": ").append(primaryOwned[i]);
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + Arrays.hashCode(this.primaryOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return Arrays.equals(this.primaryOwners, other.primaryOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ReplicatedConsistentHash> {
        public void doWriteObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.members);
            output.writeObject(ch.primaryOwners);
        }

        public ReplicatedConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            List members = (List)unmarshaller.readObject();
            int[] primaryOwners = (int[])unmarshaller.readObject();
            return new ReplicatedConsistentHash(members, primaryOwners);
        }

        public Integer getId() {
            return 28;
        }

        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }
}

