/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.WritableNamingStore;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.deployment.RuntimeBindReleaseService;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.util.NamingUtils;
import org.jboss.as.naming.util.ThreadLocalStack;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class WritableServiceBasedNamingStore
extends ServiceBasedNamingStore
implements WritableNamingStore {
    private static final ThreadLocalStack WRITE_OWNER = new ThreadLocalStack();
    private final ServiceTarget serviceTarget;

    public WritableServiceBasedNamingStore(ServiceRegistry serviceRegistry, ServiceName serviceNameBase, ServiceTarget serviceTarget) {
        super(serviceRegistry, serviceNameBase);
        this.serviceTarget = serviceTarget;
    }

    @Override
    public void bind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.bind(name, object);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        Object owner = this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        this.bind(name, object, owner, bindName);
    }

    private void bind(Name name, Object object, Object owner, ServiceName bindName) throws NamingException {
        ServiceTarget serviceTarget = this.serviceTarget;
        ServiceName deploymentUnitServiceName = null;
        if (owner instanceof ServiceName) {
            deploymentUnitServiceName = (ServiceName)owner;
        } else {
            serviceTarget = (ServiceTarget)owner;
        }
        try {
            ServiceController binderServiceController;
            BinderService binderService;
            block7: {
                binderService = new BinderService(name.toString(), null, deploymentUnitServiceName != null);
                binderService.getManagedObjectInjector().inject((Object)new ImmediateManagedReferenceFactory(object));
                ServiceBuilder builder = serviceTarget.addService(bindName, (Service)binderService).addDependency(this.getServiceNameBase(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
                binderServiceController = builder.install();
                try {
                    binderServiceController.awaitValue();
                }
                catch (IllegalStateException t) {
                    StartException startException = binderServiceController.getStartException();
                    if (startException == null) break block7;
                    throw startException;
                }
            }
            if (deploymentUnitServiceName != null) {
                binderService.acquire();
                RuntimeBindReleaseService.References duBindingReferences = (RuntimeBindReleaseService.References)binderServiceController.getServiceContainer().getService(JndiNamingDependencyProcessor.serviceName(deploymentUnitServiceName)).getValue();
                duBindingReferences.add(binderService);
            }
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to bind [" + object + "] at location [" + bindName + "]", e);
        }
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        Object owner = this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        ServiceController controller = this.getServiceRegistry().getService(bindName);
        if (controller == null) {
            this.bind(name, object, owner, bindName);
        } else {
            BinderService binderService = (BinderService)controller.getService();
            if (owner instanceof ServiceName) {
                ServiceName deploymentUnitServiceName = (ServiceName)owner;
                binderService.acquire();
                RuntimeBindReleaseService.References duBindingReferences = (RuntimeBindReleaseService.References)controller.getServiceContainer().getService(JndiNamingDependencyProcessor.serviceName(deploymentUnitServiceName)).getValue();
                duBindingReferences.add(binderService);
            }
            binderService.getManagedObjectInjector().setValue((Value)new ImmediateValue((Object)new ImmediateManagedReferenceFactory(object)));
        }
    }

    @Override
    public void rebind(Name name, Object object, Class<?> bindType) throws NamingException {
        this.rebind(name, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.requireOwner();
        ServiceName bindName = this.buildServiceName(name);
        ServiceController controller = this.getServiceRegistry().getService(bindName);
        if (controller == null) {
            throw NamingLogger.ROOT_LOGGER.cannotResolveService(bindName);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        controller.addListener(new LifecycleListener(){

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                if (event == LifecycleEvent.REMOVED) {
                    latch.countDown();
                }
            }
        });
        try {
            controller.setMode(ServiceController.Mode.REMOVE);
            latch.await();
        }
        catch (Exception e) {
            throw NamingUtils.namingException("Failed to unbind [" + bindName + "]", e);
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.requireOwner();
        if (NamingUtils.isLastComponentEmpty(name)) {
            throw NamingLogger.ROOT_LOGGER.emptyNameNotAllowed();
        }
        return new NamingContext(name, this, new Hashtable());
    }

    private Object requireOwner() {
        Object owner = WRITE_OWNER.peek();
        if (owner == null) {
            throw NamingLogger.ROOT_LOGGER.readOnlyNamingContext();
        }
        return owner;
    }

    public static void pushOwner(ServiceName deploymentUnitServiceName) {
        WRITE_OWNER.push(deploymentUnitServiceName);
    }

    public static void pushOwner(ServiceTarget serviceTarget) {
        WRITE_OWNER.push(serviceTarget);
    }

    public static void popOwner() {
        WRITE_OWNER.pop();
    }
}

