/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.Key;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.PredicateKeyFilter;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SimpleImmutableSession;
import org.wildfly.clustering.web.cache.session.ValidSession;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(primaryOnly=true)
public class InfinispanSessionManager<S, SC, AL, MV, AV, LC>
implements SessionManager<LC, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final SessionExpirationListener expirationListener;
    private final Batcher<TransactionBatch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final SessionFactory<SC, MV, AV, LC> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final Scheduler<String, ImmutableSessionMetaData> expirationScheduler;
    private final Recordable<ImmutableSession> recorder;
    private final SC context;
    private final SpecificationProvider<S, SC, AL> provider;
    private final Runnable startTask;
    private final Consumer<ImmutableSession> closeTask;
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private volatile Registration expirationRegistration;
    private volatile ExecutorService executor;

    public InfinispanSessionManager(SessionFactory<SC, MV, AV, LC> factory, final InfinispanSessionManagerConfiguration<S, SC, AL> configuration) {
        this.factory = factory;
        this.cache = configuration.getCache();
        this.properties = configuration.getProperties();
        this.expirationRegistrar = configuration.getExpirationRegistar();
        this.expirationListener = configuration.getExpirationListener();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.expirationScheduler = configuration.getExpirationScheduler();
        this.recorder = configuration.getInactiveSessionRecorder();
        this.context = configuration.getServletContext();
        this.provider = configuration.getSpecificationProvider();
        this.startTask = configuration.getStartTask();
        this.closeTask = new Consumer<ImmutableSession>(){

            @Override
            public void accept(ImmutableSession session) {
                if (session.isValid()) {
                    configuration.getExpirationScheduler().schedule((Object)session.getId(), (Object)session.getMetaData());
                }
            }
        };
    }

    public void start() {
        this.executor = new DefaultExecutorService(this.getClass(), (Function)ExecutorServiceFactory.CACHED_THREAD);
        if (this.recorder != null) {
            this.recorder.reset();
        }
        this.identifierFactory.start();
        this.expirationRegistration = this.expirationRegistrar.register((Object)this.expirationListener);
        PredicateKeyFilter filter = new PredicateKeyFilter((Predicate)((Object)SessionCreationMetaDataKeyFilter.INSTANCE));
        this.cache.addListener((Object)this, (CacheEventFilter)filter, null);
        this.cache.addListener((Object)this.factory.getMetaDataFactory(), (CacheEventFilter)filter, null);
        this.cache.addListener((Object)this.factory.getAttributesFactory(), (CacheEventFilter)filter, null);
        this.startTask.run();
    }

    public void stop() {
        this.expirationRegistration.close();
        this.cache.removeListener((Object)this);
        this.cache.removeListener((Object)this.factory.getMetaDataFactory());
        this.cache.removeListener((Object)this.factory.getAttributesFactory());
        this.identifierFactory.stop();
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Duration getStopTimeout() {
        return Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public Session<LC> findSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove((Object)id);
            return null;
        }
        this.expirationScheduler.cancel((Object)id);
        return new ValidSession(this.factory.createSession(id, value, this.context), this.closeTask);
    }

    public Session<LC> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue((Object)id, null);
        if (entry == null) {
            return null;
        }
        Session session = this.factory.createSession(id, entry, this.context);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new ValidSession(session, this.closeTask);
    }

    public ImmutableSession viewSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        CacheLocality locality = new CacheLocality(this.cache);
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            Set<String> set = keys.filter(SessionCreationMetaDataKeyFilter.INSTANCE.and(arg_0 -> InfinispanSessionManager.lambda$getSessions$0((Locality)locality, arg_0))).map(key -> (String)key.getId()).collect(Collectors.toSet());
            return set;
        }
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CacheEntryActivated
    public CompletionStage<Void> activated(CacheEntryActivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre()) return CompletableFutures.completedNull();
        if (this.properties.isPersistent()) return CompletableFutures.completedNull();
        String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getId();
        InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
        try (TransactionBatch batch = (TransactionBatch)this.batcher.suspendBatch();){
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
                    Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
                    if (value != null) {
                        ImmutableSession session = this.factory.createImmutableSession(id, value);
                        new ImmutableSessionActivationNotifier(this.provider, session, this.context).postActivate();
                    }
                }
            }, this.executor);
            return completableFuture;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return CompletableFutures.completedNull();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CacheEntryPassivated
    public CompletionStage<Void> passivated(CacheEntryPassivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (!event.isPre()) return CompletableFutures.completedNull();
        if (this.properties.isPersistent()) return CompletableFutures.completedNull();
        String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getId();
        InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
        try (TransactionBatch batch = (TransactionBatch)this.batcher.suspendBatch();){
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
                    Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
                    if (value != null) {
                        ImmutableSession session = this.factory.createImmutableSession(id, value);
                        new ImmutableSessionActivationNotifier(this.provider, session, this.context).prePassivate();
                    }
                }
            }, this.executor);
            return completableFuture;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return CompletableFutures.completedNull();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CacheEntryRemoved
    public CompletionStage<Void> removed(CacheEntryRemovedEvent<SessionCreationMetaDataKey, ?> event) {
        if (!event.isPre()) return CompletableFutures.completedNull();
        String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getId();
        InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
        if (this.recorder == null) return CompletableFutures.completedNull();
        try (TransactionBatch batch = (TransactionBatch)this.batcher.suspendBatch();){
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
                    Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
                    if (value != null) {
                        ImmutableSession session = this.factory.createImmutableSession(id, value);
                        this.recorder.record((Object)session);
                    }
                }
            }, this.executor);
            return completableFuture;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return CompletableFutures.completedNull();
    }

    private static /* synthetic */ boolean lambda$getSessions$0(Locality locality, Object key) {
        return locality.isLocal(key);
    }
}

