/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collections;
import java.util.EnumSet;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.UndertowSessionAttributeImmutability;
import org.wildfly.clustering.web.undertow.session.UndertowSpecificationProvider;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;

public class SessionManagerFactoryConfigurationAdapter<C>
extends WebDeploymentConfigurationAdapter
implements SessionManagerFactoryConfiguration<HttpSession, ServletContext, HttpSessionActivationListener, C, LocalSessionContext> {
    private final Integer maxActiveSessions;
    private final MarshalledValueFactory<C> marshalledValueFactory;
    private final LocalContextFactory<LocalSessionContext> localContextFactory = new LocalSessionContextFactory();
    private final Immutability immutability;

    public SessionManagerFactoryConfigurationAdapter(org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration configuration, MarshalledValueFactory<C> marshalledValueFactory, Immutability immutability) {
        super((WebDeploymentConfiguration)configuration);
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        this.marshalledValueFactory = marshalledValueFactory;
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        this.immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(UndertowSessionAttributeImmutability.class), loadedImmutability, Collections.singleton(immutability)}));
    }

    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public MarshalledValueFactory<C> getMarshalledValueFactory() {
        return this.marshalledValueFactory;
    }

    public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
        return this.localContextFactory;
    }

    public Immutability getImmutability() {
        return this.immutability;
    }

    public SpecificationProvider<HttpSession, ServletContext, HttpSessionActivationListener> getSpecificationProvider() {
        return UndertowSpecificationProvider.INSTANCE;
    }
}

