/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class ExceptionMarshaller<E extends Throwable>
implements ProtoStreamMarshaller<E> {
    private final Class<E> exceptionClass;
    private final Constructor<E> emptyConstructor;
    private final Constructor<E> messageConstructor;
    private final Constructor<E> causeConstructor;
    private final Constructor<E> messageCauseConstructor;

    public ExceptionMarshaller(Class<E> exceptionClass) {
        this.exceptionClass = exceptionClass;
        this.emptyConstructor = this.getConstructor(new Class[0]);
        this.messageConstructor = this.getConstructor(String.class);
        this.causeConstructor = this.getConstructor(Throwable.class);
        this.messageCauseConstructor = this.getConstructor(String.class, Throwable.class);
    }

    private Constructor<E> getConstructor(Class<?> ... parameterTypes) {
        try {
            return this.exceptionClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Class<? extends E> getJavaClass() {
        return this.exceptionClass;
    }

    public E readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        int i;
        String message = (String)AnyField.STRING.cast(String.class).readFrom(context, reader);
        Throwable cause = (Throwable)ObjectMarshaller.INSTANCE.readFrom(context, reader);
        E exception = this.createException(message, cause);
        int stackTraceSize = reader.readUInt32();
        if (stackTraceSize > 0) {
            StackTraceElement[] stackTrace = new StackTraceElement[stackTraceSize];
            for (i = 0; i < stackTraceSize; ++i) {
                String className = (String)ObjectMarshaller.INSTANCE.readFrom(context, reader);
                String methodName = (String)ObjectMarshaller.INSTANCE.readFrom(context, reader);
                String fileName = (String)ObjectMarshaller.INSTANCE.readFrom(context, reader);
                int lineNumber = reader.readUInt32();
                stackTrace[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            ((Throwable)exception).setStackTrace(stackTrace);
        }
        int suppressed = reader.readUInt32();
        for (i = 0; i < suppressed; ++i) {
            ((Throwable)exception).addSuppressed((Throwable)ObjectMarshaller.INSTANCE.readFrom(context, reader));
        }
        return exception;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, E exception) throws IOException {
        String message = ((Throwable)exception).getMessage();
        Throwable cause = ((Throwable)exception).getCause();
        AnyField.STRING.writeTo(context, writer, cause == null || !cause.toString().equals(message) ? message : null);
        ObjectMarshaller.INSTANCE.writeTo(context, writer, ((Throwable)exception).getCause());
        StackTraceElement[] stackTrace = ((Throwable)exception).getStackTrace();
        writer.writeUInt32NoTag(stackTrace.length);
        for (StackTraceElement element : stackTrace) {
            for (String elementField : new String[]{element.getClassName(), element.getMethodName(), element.getFileName()}) {
                ObjectMarshaller.INSTANCE.writeTo(context, writer, elementField);
            }
            writer.writeUInt32NoTag(element.getLineNumber());
        }
        Throwable[] suppressed = ((Throwable)exception).getSuppressed();
        writer.writeUInt32NoTag(suppressed.length);
        for (Throwable suppression : suppressed) {
            ObjectMarshaller.INSTANCE.writeTo(context, writer, suppression);
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, E exception) {
        String message = ((Throwable)exception).getMessage();
        Throwable cause = ((Throwable)exception).getCause();
        OptionalInt size = ObjectMarshaller.INSTANCE.size(context, cause);
        if (size.isPresent()) {
            OptionalInt messageSize = AnyField.STRING.size(context, cause == null || !cause.toString().equals(message) ? message : null);
            StackTraceElement[] stackTrace = ((Throwable)exception).getStackTrace();
            int stackTraceSize = Predictable.unsignedIntSize(stackTrace.length);
            for (StackTraceElement element : stackTrace) {
                stackTraceSize += ObjectMarshaller.INSTANCE.size(context, element.getClassName()).getAsInt();
                stackTraceSize += ObjectMarshaller.INSTANCE.size(context, element.getMethodName()).getAsInt();
                stackTraceSize += ObjectMarshaller.INSTANCE.size(context, element.getFileName()).getAsInt();
                stackTraceSize += Predictable.unsignedIntSize(element.getLineNumber());
            }
            size = OptionalInt.of(size.getAsInt() + messageSize.getAsInt() + stackTraceSize);
            Throwable[] suppressed = ((Throwable)exception).getSuppressed();
            size = OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(suppressed.length));
            for (Throwable suppression : suppressed) {
                OptionalInt suppressionSize = ObjectMarshaller.INSTANCE.size(context, suppression);
                size = size.isPresent() && suppressionSize.isPresent() ? OptionalInt.of(size.getAsInt() + suppressionSize.getAsInt()) : OptionalInt.empty();
            }
        }
        return size;
    }

    private E createException(String message, Throwable cause) throws IOException {
        try {
            Throwable exception;
            if (cause != null) {
                if (message != null) {
                    if (this.messageCauseConstructor != null) {
                        return (E)((Throwable)this.messageCauseConstructor.newInstance(message, cause));
                    }
                } else if (this.causeConstructor != null) {
                    return (E)((Throwable)this.causeConstructor.newInstance(cause));
                }
            }
            Throwable throwable = message != null ? (this.messageConstructor != null ? (Throwable)this.messageConstructor.newInstance(message) : null) : (exception = this.emptyConstructor != null ? (Throwable)this.emptyConstructor.newInstance(new Object[0]) : null);
            if (exception == null) {
                throw new NoSuchMethodException(String.format("%s(%s)", this.exceptionClass.getName(), message != null ? String.class.getName() : ""));
            }
            if (cause != null) {
                exception.initCause(cause);
            }
            return (E)exception;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

