/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.security.auth.Subject;
import org.infinispan.commons.jdkspecific.CallerId;
import org.infinispan.security.CachePermission;

public final class Security {
    private static final ThreadLocal<Boolean> PRIVILEGED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Deque<Subject>> SUBJECT = new ThreadLocal();

    private static boolean isTrustedClass(Class<?> klass) {
        String packageName = klass.getPackage().getName();
        return packageName.startsWith("org.infinispan") || packageName.startsWith("org.jboss.as.clustering.infinispan");
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass((int)3))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass((int)3))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        try {
            return action.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    private static Deque<Subject> pre(Subject subject) {
        Deque<Subject> stack = SUBJECT.get();
        if (stack == null) {
            stack = new ArrayDeque<Subject>();
            SUBJECT.set(stack);
        }
        if (subject != null) {
            stack.push(subject);
        }
        return stack;
    }

    private static void post(Subject subject, Deque<Subject> stack) {
        if (subject != null) {
            stack.pop();
            if (stack.isEmpty()) {
                SUBJECT.remove();
            }
        }
    }

    public static void doAs(Subject subject, Runnable action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            action.run();
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            T t = action.run();
            return t;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Deque<Subject> stack = Security.pre(subject);
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            Security.post(subject, stack);
        }
    }

    public static void checkPermission(CachePermission permission) throws AccessControlException {
        if (!Security.isPrivileged()) {
            throw new AccessControlException("Call from unprivileged code", permission);
        }
    }

    public static boolean isPrivileged() {
        return PRIVILEGED.get();
    }

    public static Subject getSubject() {
        if (SUBJECT.get() != null) {
            return SUBJECT.get().peek();
        }
        AccessControlContext acc = AccessController.getContext();
        if (System.getSecurityManager() == null) {
            return Subject.getSubject(acc);
        }
        return AccessController.doPrivileged(() -> Subject.getSubject(acc));
    }

    public static Principal getSubjectUserPrincipal(Subject s) {
        if (s != null && !s.getPrincipals().isEmpty()) {
            return s.getPrincipals().iterator().next();
        }
        return null;
    }
}

