/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class ClusteringConfiguration
implements Matchable<ClusteringConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<CacheMode> CACHE_MODE = AttributeDefinition.builder((String)"cacheMode", (Object)((Object)CacheMode.LOCAL)).serializer((AttributeSerializer)new AttributeSerializer<CacheMode, ClusteringConfiguration, ConfigurationBuilderInfo>(){

        public String getSerializationName(org.infinispan.commons.configuration.attributes.Attribute<CacheMode> attribute, ClusteringConfiguration element) {
            if (element.cacheMode().isClustered()) {
                return Attribute.MODE.getLocalName();
            }
            return null;
        }

        public Object getSerializationValue(org.infinispan.commons.configuration.attributes.Attribute<CacheMode> attribute, ClusteringConfiguration element) {
            CacheMode cacheMode = (CacheMode)((Object)attribute.get());
            if (cacheMode.isClustered()) {
                return cacheMode.toString().split("_")[1];
            }
            return null;
        }

        public boolean canRead(String name, AttributeDefinition attributeDefinition) {
            return name != null && name.equals(Attribute.MODE.getLocalName());
        }

        public Object readAttributeValue(String enclosing, AttributeDefinition attributeDefinition, Object value, ConfigurationBuilderInfo builderInfo) {
            return CacheMode.fromParts(enclosing.substring(0, enclosing.indexOf("-")), value.toString());
        }
    }).immutable().build();
    public static final AttributeDefinition<Long> REMOTE_TIMEOUT = AttributeDefinition.builder((String)"remoteTimeout", (Object)TimeUnit.SECONDS.toMillis(15L)).build();
    public static final AttributeDefinition<Integer> INVALIDATION_BATCH_SIZE = AttributeDefinition.builder((String)"invalidationBatchSize", (Object)128).immutable().build();
    public static final AttributeDefinition<BiasAcquisition> BIAS_ACQUISITION = AttributeDefinition.builder((String)"biasAcquisition", (Object)((Object)BiasAcquisition.ON_WRITE)).immutable().build();
    public static final AttributeDefinition<Long> BIAS_LIFESPAN = AttributeDefinition.builder((String)"biasLifespan", (Object)TimeUnit.MINUTES.toMillis(5L)).immutable().build();
    private final List<ConfigurationInfo> elements;
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.CLUSTERING.getLocalName(), false);
    private final org.infinispan.commons.configuration.attributes.Attribute<CacheMode> cacheMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> remoteTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> invalidationBatchSize;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteringConfiguration.class, new AttributeDefinition[]{CACHE_MODE, REMOTE_TIMEOUT, INVALIDATION_BATCH_SIZE, BIAS_ACQUISITION, BIAS_LIFESPAN});
    }

    ClusteringConfiguration(AttributeSet attributes, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        this.attributes = attributes.checkProtection();
        this.cacheMode = attributes.attribute(CACHE_MODE);
        this.remoteTimeout = attributes.attribute(REMOTE_TIMEOUT);
        this.invalidationBatchSize = attributes.attribute(INVALIDATION_BATCH_SIZE);
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
        this.elements = Arrays.asList(hashConfiguration, l1Configuration, stateTransferConfiguration, partitionHandlingStrategy);
    }

    public CacheMode cacheMode() {
        return (CacheMode)((Object)this.cacheMode.get());
    }

    public long remoteTimeout() {
        return (Long)this.attributes.attribute(REMOTE_TIMEOUT).get();
    }

    public void remoteTimeout(long timeoutMillis) {
        this.attributes.attribute(REMOTE_TIMEOUT).set((Object)timeoutMillis);
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode() == null ? "none" : this.cacheMode().toString();
    }

    public int invalidationBatchSize() {
        return (Integer)this.invalidationBatchSize.get();
    }

    public BiasAcquisition biasAcquisition() {
        return (BiasAcquisition)((Object)this.attributes.attribute(BIAS_ACQUISITION).get());
    }

    public long biasLifespan() {
        return (Long)this.attributes.attribute(BIAS_LIFESPAN).get();
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public boolean matches(ClusteringConfiguration other) {
        return this.attributes.matches(other.attributes) && this.hashConfiguration.matches(other.hashConfiguration) && this.l1Configuration.matches(other.l1Configuration) && this.partitionHandlingConfiguration.matches(other.partitionHandlingConfiguration) && this.stateTransferConfiguration.matches(other.stateTransferConfiguration);
    }

    public String toString() {
        return "ClusteringConfiguration [hashConfiguration=" + this.hashConfiguration + ", l1Configuration=" + this.l1Configuration + ", stateTransferConfiguration=" + this.stateTransferConfiguration + ", partitionHandlingConfiguration=" + this.partitionHandlingConfiguration + ", attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusteringConfiguration other = (ClusteringConfiguration)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes)) {
            return false;
        }
        if (this.hashConfiguration == null ? other.hashConfiguration != null : !this.hashConfiguration.equals(other.hashConfiguration)) {
            return false;
        }
        if (this.l1Configuration == null ? other.l1Configuration != null : !this.l1Configuration.equals(other.l1Configuration)) {
            return false;
        }
        if (this.partitionHandlingConfiguration == null ? other.partitionHandlingConfiguration != null : !this.partitionHandlingConfiguration.equals(other.partitionHandlingConfiguration)) {
            return false;
        }
        return !(this.stateTransferConfiguration == null ? other.stateTransferConfiguration != null : !this.stateTransferConfiguration.equals(other.stateTransferConfiguration));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.hashConfiguration == null ? 0 : this.hashConfiguration.hashCode());
        result = 31 * result + (this.l1Configuration == null ? 0 : this.l1Configuration.hashCode());
        result = 31 * result + (this.partitionHandlingConfiguration == null ? 0 : this.partitionHandlingConfiguration.hashCode());
        result = 31 * result + (this.stateTransferConfiguration == null ? 0 : this.stateTransferConfiguration.hashCode());
        return result;
    }
}

