/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.GenericConfig;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class BulkheadConfig
extends GenericConfig<Bulkhead> {
    public static final String VALUE = "value";
    public static final String WAITING_TASK_QUEUE = "waitingTaskQueue";
    private static final String INVALID_BULKHEAD_ON = "Invalid @Bulkhead on ";
    private static Map<String, Class<?>> keys2Type = BulkheadConfig.initKeys();

    public BulkheadConfig(Class<?> beanClass, Method method) {
        super(Bulkhead.class, beanClass, method);
    }

    public BulkheadConfig(AnnotatedMethod<?> annotatedMethod) {
        super(Bulkhead.class, annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.get(VALUE, Integer.class) < 0) {
            throw new FaultToleranceDefinitionException(INVALID_BULKHEAD_ON + this.getMethodInfo() + " : value shouldn't be lower than 0");
        }
        if (this.get(WAITING_TASK_QUEUE, Integer.class) < 1) {
            throw new FaultToleranceDefinitionException(INVALID_BULKHEAD_ON + this.getMethodInfo() + " : waitingTaskQueue shouldn't be lower than 1");
        }
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class<Integer>> keys = new HashMap<String, Class<Integer>>();
        keys.put(VALUE, Integer.class);
        keys.put(WAITING_TASK_QUEUE, Integer.class);
        return Collections.unmodifiableMap(keys);
    }
}

