/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes.pem;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;

public class PEMReader {
    public static final String PRIVATE_PKCS1_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_PKCS8_MARKER = "-----BEGIN PRIVATE KEY-----";
    public static final String CERTIFICATE_X509_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_X509_MARKER = "-----BEGIN PUBLIC KEY-----";
    private static final String BEGIN_MARKER = "-----BEGIN ";
    private final InputStream stream;
    private byte[] derBytes;
    private String beginMarker;

    public PEMReader(InputStream inStream) throws IOException {
        this.stream = inStream;
        this.readFile();
    }

    public PEMReader(byte[] buffer) throws IOException {
        this(new ByteArrayInputStream(buffer));
    }

    public PEMReader(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public byte[] getDerBytes() {
        return this.derBytes;
    }

    public String getBeginMarker() {
        return this.beginMarker;
    }

    protected void readFile() throws IOException {
        Throwable throwable = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(BEGIN_MARKER)) continue;
                this.beginMarker = line.trim();
                String endMarker = this.beginMarker.replace("BEGIN", "END");
                this.derBytes = PEMReader.readBytes(reader, endMarker);
                return;
            }
            try {
                throw new IOException("Invalid PEM file: no begin marker");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static byte[] readBytes(BufferedReader reader, String endMarker) throws IOException {
        String line = null;
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.contains(endMarker)) {
                return Base64.getDecoder().decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("Invalid PEM file: No end marker");
    }
}

