/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public abstract class AbstractPlatformBindingProcessor
implements DeploymentUnitProcessor {
    private static final String JAVA_COMP = "java:comp/";
    private static final String JAVA_MODULE = "java:module/";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        this.addBindings(deploymentUnit, moduleDescription);
    }

    protected abstract void addBindings(DeploymentUnit var1, EEModuleDescription var2);

    protected void addBinding(String source, String target, DeploymentUnit deploymentUnit, EEModuleDescription moduleDescription) {
        LookupInjectionSource injectionSource = new LookupInjectionSource(source);
        String moduleTarget = JAVA_MODULE + target;
        moduleDescription.getBindingConfigurations().add(new BindingConfiguration(moduleTarget, injectionSource));
        if (!DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit)) {
            String compTarget = JAVA_COMP + target;
            for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                if (componentDescription.getNamingMode() != ComponentNamingMode.CREATE) continue;
                componentDescription.getBindingConfigurations().add(new BindingConfiguration(compTarget, injectionSource));
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

