/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public final class DiscoveryGroup
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(DiscoveryGroup.class);
    private final List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    private final String name;
    private Thread thread;
    private boolean received;
    private final Object waitLock = new Object();
    private final Map<String, DiscoveryEntry> connectors = new ConcurrentHashMap<String, DiscoveryEntry>();
    private final long timeout;
    private volatile boolean started;
    private final String nodeID;
    private final Map<String, String> uniqueIDMap = new HashMap<String, String>();
    private final BroadcastEndpoint endpoint;
    private final NotificationService notificationService;

    public DiscoveryGroup(String nodeID, String name, long timeout, BroadcastEndpointFactory endpointFactory, NotificationService service) throws Exception {
        this.nodeID = nodeID;
        this.name = name;
        this.timeout = timeout;
        this.endpoint = endpointFactory.createBroadcastEndpoint();
        this.notificationService = service;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.endpoint.openClient();
        this.started = true;
        this.thread = new Thread((Runnable)new DiscoveryRunnable(), "activemq-discovery-group-thread-" + this.name);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, CoreNotificationType.DISCOVERY_GROUP_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    public void internalRunning() throws Exception {
        this.endpoint.openClient();
        this.started = true;
        DiscoveryRunnable runnable = new DiscoveryRunnable();
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
        try {
            this.endpoint.close(false);
        }
        catch (Exception e1) {
            ActiveMQClientLogger.LOGGER.errorStoppingDiscoveryBroadcastEndpoint(this.endpoint, e1);
        }
        try {
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread.join(10000L);
                if (this.thread.isAlive()) {
                    ActiveMQClientLogger.LOGGER.timedOutStoppingDiscovery();
                }
            }
        }
        catch (InterruptedException e) {
            throw new ActiveMQInterruptedException(e);
        }
        this.thread = null;
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), new SimpleString(this.name));
            Notification notification = new Notification(this.nodeID, CoreNotificationType.DISCOVERY_GROUP_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.errorSendingNotifOnDiscoveryStop(e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public String getName() {
        return this.name;
    }

    public synchronized List<DiscoveryEntry> getDiscoveryEntries() {
        return new ArrayList<DiscoveryEntry>(this.connectors.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForBroadcast(long timeout) {
        Object object = this.waitLock;
        synchronized (object) {
            long start = System.currentTimeMillis();
            long toWait = timeout;
            while (this.started && !this.received && (toWait > 0L || timeout == 0L)) {
                try {
                    this.waitLock.wait(toWait);
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException(e);
                }
                if (timeout == 0L) continue;
                long now = System.currentTimeMillis();
                toWait -= now - start;
                start = now;
            }
            boolean ret = this.received;
            this.received = false;
            return ret;
        }
    }

    private void checkUniqueID(String originatingNodeID, String uniqueID) {
        String currentUniqueID = this.uniqueIDMap.get(originatingNodeID);
        if (currentUniqueID == null) {
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        } else if (!currentUniqueID.equals(uniqueID)) {
            ActiveMQClientLogger.LOGGER.multipleServersBroadcastingSameNode(originatingNodeID);
            this.uniqueIDMap.put(originatingNodeID, uniqueID);
        }
    }

    public synchronized void registerListener(DiscoveryListener listener) {
        this.listeners.add(listener);
        if (!this.connectors.isEmpty()) {
            listener.connectorsChanged(this.getDiscoveryEntries());
        }
    }

    public synchronized void unregisterListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    private void callListeners() {
        for (DiscoveryListener listener : this.listeners) {
            try {
                listener.connectorsChanged(this.getDiscoveryEntries());
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.failedToCallListenerInDiscovery(t);
            }
        }
    }

    private boolean checkExpiration() {
        boolean changed = false;
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, DiscoveryEntry>> iter = this.connectors.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, DiscoveryEntry> entry = iter.next();
            if (entry.getValue().getLastUpdate() + this.timeout > now) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Timed out node on discovery:" + entry.getValue());
            }
            iter.remove();
            changed = true;
        }
        return changed;
    }

    class DiscoveryRunnable
    implements Runnable {
        DiscoveryRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] data = null;
            while (DiscoveryGroup.this.started) {
                try {
                    block18: {
                        try {
                            data = DiscoveryGroup.this.endpoint.receiveBroadcast();
                            if (data != null) break block18;
                            if (!DiscoveryGroup.this.started) break;
                            ActiveMQClientLogger.LOGGER.unexpectedNullDataReceived();
                            break;
                        }
                        catch (Exception e) {
                            if (!DiscoveryGroup.this.started) {
                                return;
                            }
                            ActiveMQClientLogger.LOGGER.errorReceivingPacketInDiscovery(e);
                        }
                    }
                    ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer(data);
                    String originatingNodeID = buffer.readString();
                    String uniqueID = buffer.readString();
                    DiscoveryGroup.this.checkUniqueID(originatingNodeID, uniqueID);
                    if (DiscoveryGroup.this.nodeID.equals(originatingNodeID)) {
                        if (!DiscoveryGroup.this.checkExpiration()) continue;
                        DiscoveryGroup.this.callListeners();
                        continue;
                    }
                    int size = buffer.readInt();
                    boolean changed = false;
                    DiscoveryEntry[] entriesRead = new DiscoveryEntry[size];
                    for (int i = 0; i < size; ++i) {
                        TransportConfiguration transportConfiguration = new TransportConfiguration();
                        transportConfiguration.decode(buffer);
                        entriesRead[i] = new DiscoveryEntry(originatingNodeID, transportConfiguration, System.currentTimeMillis());
                    }
                    Iterator iterator = DiscoveryGroup.this;
                    synchronized (iterator) {
                        for (DiscoveryEntry entry : entriesRead) {
                            if (DiscoveryGroup.this.connectors.put(originatingNodeID, entry) != null) continue;
                            changed = true;
                        }
                        changed = changed || DiscoveryGroup.this.checkExpiration();
                    }
                    if (changed && DiscoveryGroup.this.started) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Connectors changed on Discovery:");
                            for (DiscoveryEntry discoveryEntry : DiscoveryGroup.this.connectors.values()) {
                                logger.trace(discoveryEntry);
                            }
                        }
                        DiscoveryGroup.this.callListeners();
                    }
                    iterator = DiscoveryGroup.this.waitLock;
                    synchronized (iterator) {
                        DiscoveryGroup.this.received = true;
                        DiscoveryGroup.this.waitLock.notifyAll();
                    }
                }
                catch (Throwable e) {
                    ActiveMQClientLogger.LOGGER.failedToReceiveDatagramInDiscovery(e);
                }
            }
        }
    }
}

