/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public abstract class AbstractForEachIntOperation<Original, K>
extends BaseTerminalOperation<Original>
implements KeyTrackingTerminalOperation<Original, K, Integer> {
    private final int batchSize;
    private final Function<? super Original, ? extends K> toKeyFunction;

    public AbstractForEachIntOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<Original>> supplier, Function<? super Original, ? extends K> toKeyFunction, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
        this.toKeyFunction = toKeyFunction;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<Integer> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<Integer>> response) {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleArray(int[] var1, int var2);

    @Override
    public Collection<K> performForEachOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<K>> response) {
        Stream<Object> originalStream = (Stream<Object>)((Stream)this.supplier.get()).sequential();
        ArrayList<Object> collectedValues = new ArrayList<Object>(this.batchSize);
        int[] list = new int[this.batchSize];
        AtomicInteger offset = new AtomicInteger();
        Object[] currentKey = new Object[1];
        Stream<Object> stream = originalStream = originalStream.peek(e -> {
            if (offset.get() > 0) {
                collectedValues.add(currentKey[0]);
                if (collectedValues.size() >= this.batchSize) {
                    this.handleArray(list, offset.get());
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    offset.set(0);
                }
            }
            currentKey[0] = this.toKeyFunction.apply(e);
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        IntStream convertedStream = (IntStream)((Object)stream);
        convertedStream.forEach(d -> {
            list[offset.getAndIncrement()] = d;
        });
        if (offset.get() > 0) {
            this.handleArray(list, offset.get());
            collectedValues.add(currentKey[0]);
        }
        return collectedValues;
    }

    public Function<? super Original, ? extends K> getToKeyFunction() {
        return this.toKeyFunction;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

