/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.JWTParser;
import io.smallrye.jwt.auth.principal.ParseException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class DefaultJWTParser
implements JWTParser {
    @Inject
    private JWTAuthContextInfo authContextInfo;
    private volatile JWTCallerPrincipalFactory callerPrincipalFactory;

    @Override
    public JsonWebToken parse(String bearerToken) throws ParseException {
        return this.getcallerPrincipalFactory().parse(bearerToken, this.authContextInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JWTCallerPrincipalFactory getcallerPrincipalFactory() {
        if (this.callerPrincipalFactory == null) {
            DefaultJWTParser defaultJWTParser = this;
            synchronized (defaultJWTParser) {
                if (this.callerPrincipalFactory == null) {
                    this.callerPrincipalFactory = JWTCallerPrincipalFactory.instance();
                }
            }
        }
        return this.callerPrincipalFactory;
    }
}

