/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Set;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationExecutor;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;

public class StreamingOperationExecutorSelector
implements IndexWorkVisitor<Void, StreamingOperationExecutor> {
    private final AddSelectionExecutor addExecutor = new AddSelectionExecutor();
    private final DeleteSelectionExecutor deleteExecutor = new DeleteSelectionExecutor();
    private final AllSelectionExecutor allManagersExecutor = new AllSelectionExecutor();
    private final PurgeAllSelectionExecutor purgeExecutor = new PurgeAllSelectionExecutor();
    private final DeleteByQuerySelectionExecutor deleteByQueryExecutor = new DeleteByQuerySelectionExecutor();
    public static final StreamingOperationExecutorSelector INSTANCE = new StreamingOperationExecutorSelector();

    private StreamingOperationExecutorSelector() {
    }

    @Override
    public StreamingOperationExecutor visitAddWork(AddLuceneWork addLuceneWork, Void p) {
        return this.addExecutor;
    }

    @Override
    public StreamingOperationExecutor visitUpdateWork(UpdateLuceneWork updateLuceneWork, Void p) {
        return this.addExecutor;
    }

    @Override
    public StreamingOperationExecutor visitDeleteWork(DeleteLuceneWork deleteLuceneWork, Void p) {
        return this.deleteExecutor;
    }

    @Override
    public StreamingOperationExecutor visitOptimizeWork(OptimizeLuceneWork optimizeLuceneWork, Void p) {
        return this.allManagersExecutor;
    }

    @Override
    public StreamingOperationExecutor visitPurgeAllWork(PurgeAllLuceneWork purgeAllLuceneWork, Void p) {
        return this.purgeExecutor;
    }

    @Override
    public StreamingOperationExecutor visitFlushWork(FlushLuceneWork flushLuceneWork, Void p) {
        return this.allManagersExecutor;
    }

    @Override
    public StreamingOperationExecutor visitDeleteByQueryWork(DeleteByQueryLuceneWork deleteByQueryLuceneWork, Void p) {
        return this.deleteByQueryExecutor;
    }

    private static class PurgeAllSelectionExecutor
    implements StreamingOperationExecutor {
        private PurgeAllSelectionExecutor() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexManagerSelector selector, IndexingMonitor monitor, boolean forceAsync) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class AllSelectionExecutor
    implements StreamingOperationExecutor {
        private AllSelectionExecutor() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexManagerSelector selector, IndexingMonitor monitor, boolean forceAsync) {
            Set<IndexManager> indexManagers = selector.all();
            for (IndexManager indexManager : indexManagers) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class DeleteSelectionExecutor
    implements StreamingOperationExecutor {
        private DeleteSelectionExecutor() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexManagerSelector selector, IndexingMonitor monitor, boolean forceAsync) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }

    private static class AddSelectionExecutor
    implements StreamingOperationExecutor {
        private AddSelectionExecutor() {
        }

        @Override
        public final void performStreamOperation(LuceneWork work, IndexManagerSelector selector, IndexingMonitor monitor, boolean forceAsync) {
            IndexManager indexManager = selector.forNew(work.getEntityType(), work.getId(), work.getIdInString(), work.getDocument());
            indexManager.performStreamOperation(work, monitor, forceAsync);
        }
    }

    private static class DeleteByQuerySelectionExecutor
    implements StreamingOperationExecutor {
        private DeleteByQuerySelectionExecutor() {
        }

        @Override
        public void performStreamOperation(LuceneWork work, IndexManagerSelector selector, IndexingMonitor monitor, boolean forceAsync) {
            Set<IndexManager> indexManagers = selector.forExisting(work.getEntityType(), work.getId(), work.getIdInString());
            for (IndexManager indexManager : indexManagers) {
                indexManager.performStreamOperation(work, monitor, forceAsync);
            }
        }
    }
}

