/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.extension.messaging.activemq.AcceptorControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public abstract class AbstractTransportDefinition
extends PersistentResourceDefinition {
    public static final String CONNECTOR_CAPABILITY_NAME = "org.wildfly.messaging.activemq.connector";
    public static final String ACCEPTOR_CAPABILITY_NAME = "org.wildfly.messaging.activemq.acceptor";
    private final boolean registerRuntimeOnly;
    private final AttributeDefinition[] attrs;
    protected final boolean isAcceptor;

    protected AbstractTransportDefinition(boolean isAcceptor, final String specificType, boolean registerRuntimeOnly, AttributeDefinition ... attrs) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)specificType), (ResourceDescriptionResolver)new StandardResourceDescriptionResolver(isAcceptor ? "acceptor" : "connector", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString(specificType);
            }
        }).setCapabilities(new RuntimeCapability[]{RuntimeCapability.Builder.of((String)(isAcceptor ? ACCEPTOR_CAPABILITY_NAME : CONNECTOR_CAPABILITY_NAME), (boolean)true).setDynamicNameMapper((Function)TransportCapabilityNameMapper.INSTANCE).build()}).setAddHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.AddStepHandler(attrs)).setRemoveHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.RemoveStepHandler()));
        this.isAcceptor = isAcceptor;
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.attrs = attrs;
    }

    protected AbstractTransportDefinition(boolean isAcceptor, final String specificType, boolean registerRuntimeOnly, ModelVersion deprecatedSince, AttributeDefinition ... attrs) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)specificType), (ResourceDescriptionResolver)new StandardResourceDescriptionResolver(isAcceptor ? "acceptor" : "connector", MessagingExtension.RESOURCE_NAME, MessagingExtension.class.getClassLoader(), true, false){

            public String getResourceDescription(Locale locale, ResourceBundle bundle) {
                return bundle.getString(specificType);
            }
        }).setAddHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.AddStepHandler(attrs)).setRemoveHandler((OperationStepHandler)new ActiveMQReloadRequiredHandlers.RemoveStepHandler()).setDeprecatedSince(deprecatedSince));
        this.isAcceptor = isAcceptor;
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.attrs = attrs;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.attrs);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler attributeHandler = new ReloadRequiredWriteAttributeHandler(this.attrs);
        for (AttributeDefinition attr : this.attrs) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)attributeHandler);
        }
        if (this.isAcceptor) {
            AcceptorControlHandler.INSTANCE.registerAttributes(registry);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.isAcceptor && this.registerRuntimeOnly) {
            AcceptorControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        super.registerOperations(registry);
    }

    public static class TransportCapabilityReferenceRecorder
    extends CapabilityReferenceRecorder.ResourceCapabilityReferenceRecorder {
        private final boolean external;

        public TransportCapabilityReferenceRecorder(String baseDependentName, String baseRequirementName, boolean external) {
            super(external ? DynamicNameMappers.SIMPLE : DynamicNameMappers.PARENT, baseDependentName, (Function)TransportCapabilityNameMapper.INSTANCE, baseRequirementName);
            this.external = external;
        }

        public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove, String ... attributeValues) {
            String dependentName = this.getDependentName(context.getCurrentAddress());
            String requirement = this.getRequirementName(context.getCurrentAddress());
            for (String att : attributeValues) {
                String requirementName = RuntimeCapability.buildDynamicCapabilityName((String)requirement, (String)att);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName, attributeName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        private String getDependentName(PathAddress address) {
            if (this.external) {
                return RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseDependentName(), (String[])((String[])DynamicNameMappers.SIMPLE.apply(address)));
            }
            return RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseDependentName(), (String[])((String[])DynamicNameMappers.PARENT.apply(address)));
        }

        private String getRequirementName(PathAddress address) {
            PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
            if (serverAddress.size() > 0) {
                return RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String)serverAddress.getLastElement().getValue());
            }
            return this.getBaseRequirementName();
        }

        public String getBaseRequirementName() {
            if (this.external) {
                return super.getBaseRequirementName() + ".external";
            }
            return super.getBaseRequirementName();
        }

        public String[] getRequirementPatternSegments(String dynamicElement, PathAddress registrationAddress) {
            String[] dynamicElements = !this.external ? new String[]{"$server"} : new String[]{};
            if (dynamicElement != null && !dynamicElement.isEmpty()) {
                String[] result = new String[dynamicElements.length + 1];
                for (int i = 0; i < dynamicElements.length; ++i) {
                    result[i] = dynamicElements[i].charAt(0) == '$' ? dynamicElements[i].substring(1) : dynamicElements[i];
                }
                result[dynamicElements.length] = dynamicElement;
                return result;
            }
            return dynamicElements;
        }
    }

    private static class TransportCapabilityNameMapper
    implements Function<PathAddress, String[]> {
        private static final TransportCapabilityNameMapper INSTANCE = new TransportCapabilityNameMapper();

        private TransportCapabilityNameMapper() {
        }

        @Override
        public String[] apply(PathAddress address) {
            PathAddress serverAddress = MessagingServices.getActiveMQServerPathAddress(address);
            String[] result = new String[]{serverAddress.size() > 0 ? serverAddress.getLastElement().getValue() : "external", address.getLastElement().getValue()};
            return result;
        }
    }
}

