/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Objects;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.CurrentItem;

public class AbstractSerializerBuilder<T extends AbstractSerializerBuilder> {
    protected CurrentItem<?> wrapper;
    protected ClassModel classModel;
    protected Type runtimeType;
    protected Type genericType;
    protected Customization customization;
    protected final JsonbContext jsonbContext;

    public AbstractSerializerBuilder(JsonbContext jsonbContext) {
        Objects.requireNonNull(jsonbContext);
        this.jsonbContext = jsonbContext;
    }

    public T withWrapper(CurrentItem<?> wrapper) {
        this.wrapper = wrapper;
        return (T)this;
    }

    public T withCustomization(Customization customization) {
        this.customization = customization;
        return (T)this;
    }

    protected ClassModel getClassModel(Class<?> rawType) {
        ClassModel classModel = this.jsonbContext.getMappingContext().getClassModel(rawType);
        if (classModel == null) {
            classModel = this.jsonbContext.getMappingContext().getOrCreateClassModel(rawType);
        }
        return classModel;
    }

    public CurrentItem<?> getWrapper() {
        return this.wrapper;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public Type getRuntimeType() {
        return this.runtimeType;
    }

    public T withType(Type type) {
        this.genericType = type;
        return (T)this;
    }

    public JsonbContext getJsonbContext() {
        return this.jsonbContext;
    }

    public Customization getCustomization() {
        return this.customization;
    }
}

