/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivilegedActionException;
import org.jboss.as.controller.AccessAuditContext;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronIdentityHandler
implements HttpHandler {
    public static final AttachmentKey<SecurityIdentity> IDENTITY_KEY = AttachmentKey.create(SecurityIdentity.class);
    private final HttpHandler wrapped;

    public ElytronIdentityHandler(HttpHandler toWrap) {
        this.wrapped = toWrap;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityIdentity securityIdentity = (SecurityIdentity)exchange.getAttachment(IDENTITY_KEY);
        SocketAddress peerSocketAddress = exchange.getConnection().getPeerAddress();
        InetAddress remoteAddress = peerSocketAddress instanceof InetSocketAddress ? ((InetSocketAddress)peerSocketAddress).getAddress() : null;
        try {
            AccessAuditContext.doAs((SecurityIdentity)securityIdentity, (InetAddress)remoteAddress, () -> {
                this.wrapped.handleRequest(exchange);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }
}

