/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

@Listener(sync=false)
public class CoarseSessionAttributesFactory<V>
implements SessionAttributesFactory<Map.Entry<Map<String, Object>, V>> {
    private final Cache<SessionAttributesKey, V> cache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final CacheProperties properties;
    private final Immutability immutability;
    private final MutatorFactory<SessionAttributesKey, V> mutatorFactory;

    public CoarseSessionAttributesFactory(InfinispanSessionAttributesFactoryConfiguration<Map<String, Object>, V> configuration) {
        this.cache = configuration.getCache();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = configuration.getCacheProperties();
        this.mutatorFactory = new InfinispanMutatorFactory(this.cache, this.properties);
    }

    public Map.Entry<Map<String, Object>, V> createValue(String id, Void context) {
        AbstractMap attributes = this.properties.isLockOnRead() ? new HashMap() : new ConcurrentHashMap();
        Object value = this.marshaller.write(attributes);
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new SessionAttributesKey(id), value);
        return new AbstractMap.SimpleImmutableEntry(attributes, value);
    }

    public Map.Entry<Map<String, Object>, V> findValue(String id) {
        Object value = this.cache.get((Object)new SessionAttributesKey(id));
        if (value != null) {
            try {
                Map attributes = (Map)this.marshaller.read(value);
                return new AbstractMap.SimpleImmutableEntry<Map, Object>(attributes, value);
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public boolean remove(String id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesKey(id));
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry, ImmutableSessionMetaData metaData, ServletContext context) {
        ImmutableSessionAttributes attributes = this.createImmutableSessionAttributes(id, entry);
        ImmutableSessionActivationNotifier notifier = new ImmutableSessionActivationNotifier((ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context);
        Mutator mutator = this.properties.isTransactional() && metaData.isNew() ? Mutator.PASSIVE : this.mutatorFactory.createMutator((Object)new SessionAttributesKey(id), entry.getValue());
        return new CoarseSessionAttributes(entry.getKey(), mutator, this.marshaller, this.immutability, this.properties, (SessionActivationNotifier)notifier);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry) {
        return new CoarseImmutableSessionAttributes(entry.getKey());
    }

    @CacheEntriesEvicted
    public void evicted(CacheEntriesEvictedEvent<Key<String>, ?> event) {
        if (!event.isPre()) {
            AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
            for (Key key : event.getEntries().keySet()) {
                if (!(key instanceof SessionCreationMetaDataKey)) continue;
                cache.evict((Object)new SessionAttributesKey((String)key.getValue()));
            }
        }
    }
}

