/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.legacy;

import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryService;

public class LegacyConnectionFactoryAdd
extends AbstractAddStepHandler {
    static final LegacyConnectionFactoryAdd INSTANCE = new LegacyConnectionFactoryAdd();

    public LegacyConnectionFactoryAdd() {
        super(LegacyConnectionFactoryDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName activeMQServerServiceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        HornetQConnectionFactory incompleteCF = this.createLegacyConnectionFactory(context, model);
        ModelNode discoveryGroup = LegacyConnectionFactoryDefinition.DISCOVERY_GROUP.resolveModelAttribute(context, model);
        String discoveryGroupName = discoveryGroup.isDefined() ? discoveryGroup.asString() : null;
        LegacyConnectionFactoryService service = LegacyConnectionFactoryService.installService(name, activeMQServerServiceName, context.getServiceTarget(), incompleteCF, discoveryGroupName, LegacyConnectionFactoryDefinition.CONNECTORS.unwrap((ExpressionResolver)context, model));
        for (String legacyEntry : LegacyConnectionFactoryDefinition.ENTRIES.unwrap((ExpressionResolver)context, model)) {
            BinderServiceUtil.installBinderService(context.getServiceTarget(), legacyEntry, service, null);
        }
    }

    private HornetQConnectionFactory createLegacyConnectionFactory(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean ha = LegacyConnectionFactoryDefinition.HA.resolveModelAttribute(context, model).asBoolean();
        String factoryTypeStr = LegacyConnectionFactoryDefinition.FACTORY_TYPE.resolveModelAttribute(context, model).asString();
        JMSFactoryType factoryType = LegacyConnectionFactoryDefinition.HornetQConnectionFactoryType.valueOf(factoryTypeStr).getType();
        HornetQConnectionFactory incompleteCF = ha ? HornetQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)factoryType, (TransportConfiguration[])new TransportConfiguration[0]) : HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)factoryType, (TransportConfiguration[])new TransportConfiguration[0]);
        incompleteCF.setAutoGroup(LegacyConnectionFactoryDefinition.AUTO_GROUP.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setBlockOnAcknowledge(LegacyConnectionFactoryDefinition.BLOCK_ON_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setBlockOnDurableSend(LegacyConnectionFactoryDefinition.BLOCK_ON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setBlockOnNonDurableSend(LegacyConnectionFactoryDefinition.BLOCK_ON_NON_DURABLE_SEND.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setCacheLargeMessagesClient(LegacyConnectionFactoryDefinition.CACHE_LARGE_MESSAGE_CLIENT.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setCallFailoverTimeout(CommonAttributes.CALL_FAILOVER_TIMEOUT.resolveModelAttribute(context, model).asLong());
        incompleteCF.setCallTimeout(CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong());
        incompleteCF.setClientFailureCheckPeriod(LegacyConnectionFactoryDefinition.CLIENT_FAILURE_CHECK_PERIOD.resolveModelAttribute(context, model).asLong());
        ModelNode clientID = CommonAttributes.CLIENT_ID.resolveModelAttribute(context, model);
        if (clientID.isDefined()) {
            incompleteCF.setClientID(clientID.asString());
        }
        incompleteCF.setCompressLargeMessage(LegacyConnectionFactoryDefinition.COMPRESS_LARGE_MESSAGES.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setConfirmationWindowSize(LegacyConnectionFactoryDefinition.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        ModelNode connectionLoadBalancingClassName = LegacyConnectionFactoryDefinition.CONNECTION_LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, model);
        if (connectionLoadBalancingClassName.isDefined()) {
            incompleteCF.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingClassName.asString());
        }
        incompleteCF.setConnectionTTL(LegacyConnectionFactoryDefinition.CONNECTION_TTL.resolveModelAttribute(context, model).asLong());
        incompleteCF.setConsumerMaxRate(LegacyConnectionFactoryDefinition.CONSUMER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setConsumerWindowSize(LegacyConnectionFactoryDefinition.CONSUMER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setConfirmationWindowSize(LegacyConnectionFactoryDefinition.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setDupsOKBatchSize(LegacyConnectionFactoryDefinition.DUPS_OK_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setFailoverOnInitialConnection(LegacyConnectionFactoryDefinition.FAILOVER_ON_INITIAL_CONNECTION.resolveModelAttribute(context, model).asBoolean());
        ModelNode groupID = LegacyConnectionFactoryDefinition.GROUP_ID.resolveModelAttribute(context, model);
        if (groupID.isDefined()) {
            incompleteCF.setGroupID(groupID.asString());
        }
        incompleteCF.setInitialConnectAttempts(LegacyConnectionFactoryDefinition.INITIAL_CONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        incompleteCF.setInitialMessagePacketSize(LegacyConnectionFactoryDefinition.INITIAL_MESSAGE_PACKET_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setMaxRetryInterval(LegacyConnectionFactoryDefinition.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        incompleteCF.setMinLargeMessageSize(LegacyConnectionFactoryDefinition.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setPreAcknowledge(LegacyConnectionFactoryDefinition.PRE_ACKNOWLEDGE.resolveModelAttribute(context, model).asBoolean());
        incompleteCF.setProducerMaxRate(LegacyConnectionFactoryDefinition.PRODUCER_MAX_RATE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setProducerWindowSize(LegacyConnectionFactoryDefinition.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setReconnectAttempts(LegacyConnectionFactoryDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        incompleteCF.setRetryInterval(LegacyConnectionFactoryDefinition.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong());
        incompleteCF.setRetryIntervalMultiplier(LegacyConnectionFactoryDefinition.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble());
        incompleteCF.setScheduledThreadPoolMaxSize(LegacyConnectionFactoryDefinition.SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setThreadPoolMaxSize(LegacyConnectionFactoryDefinition.THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setTransactionBatchSize(LegacyConnectionFactoryDefinition.TRANSACTION_BATCH_SIZE.resolveModelAttribute(context, model).asInt());
        incompleteCF.setUseGlobalPools(LegacyConnectionFactoryDefinition.USE_GLOBAL_POOLS.resolveModelAttribute(context, model).asBoolean());
        return incompleteCF;
    }
}

