/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.Set;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.deployers.AbstractIntegrationProcessorJAXWS;
import org.jboss.as.webservices.deployers.ConfigResolver;
import org.jboss.as.webservices.deployers.WSEndpointConfigMapping;
import org.jboss.as.webservices.deployers.WebServiceAnnotationInfo;
import org.jboss.as.webservices.deployers.WebServiceProviderAnnotationInfo;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.ClassInfo;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

public final class WSIntegrationProcessorJAXWS_HANDLER
extends AbstractIntegrationProcessorJAXWS {
    @Override
    protected void processAnnotation(DeploymentUnit unit, EEModuleDescription moduleDescription) throws DeploymentUnitProcessingException {
        WSEndpointHandlersMapping mapping = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        VirtualFile root = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        JBossWebservicesMetaData jbossWebservicesMD = (JBossWebservicesMetaData)unit.getAttachment(WSAttachmentKeys.JBOSS_WEBSERVICES_METADATA_KEY);
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        boolean war = DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit);
        JBossWebMetaData jwmd = ASHelper.getJBossWebMetaData(unit);
        for (EEModuleClassDescription classDescription : moduleDescription.getClassDescriptions()) {
            String handlerName;
            Set<String> handlers;
            ClassAnnotationInformation providreInfo;
            ClassInfo classInfo = null;
            ClassAnnotationInformation annotationInfo = classDescription.getAnnotationInformation(WebService.class);
            if (annotationInfo != null) {
                classInfo = (ClassInfo)((WebServiceAnnotationInfo)annotationInfo.getClassLevelAnnotations().get(0)).getTarget();
            }
            if ((providreInfo = classDescription.getAnnotationInformation(WebServiceProvider.class)) != null) {
                classInfo = (ClassInfo)((WebServiceProviderAnnotationInfo)providreInfo.getClassLevelAnnotations().get(0)).getTarget();
            }
            if (classInfo == null || !ASHelper.isJaxwsEndpoint(classInfo, index, false)) continue;
            String endpointClassName = classInfo.name().toString();
            ConfigResolver configResolver = new ConfigResolver(classInfo, jbossWebservicesMD, jwmd, root, war);
            EndpointConfig config = configResolver.resolveEndpointConfig();
            if (config != null) {
                this.registerConfigMapping(endpointClassName, config, unit);
            }
            if ((handlers = this.getHandlers(endpointClassName, config, configResolver, mapping)).isEmpty()) continue;
            if (WSIntegrationProcessorJAXWS_HANDLER.isEjb3(classInfo)) {
                for (EJBEndpoint ejbEndpoint : ASHelper.getJaxwsEjbs(unit)) {
                    if (!endpointClassName.equals(ejbEndpoint.getClassName())) continue;
                    for (String handlerClassName : handlers) {
                        String ejbEndpointName = ejbEndpoint.getName();
                        handlerName = ejbEndpointName + "-" + handlerClassName;
                        ComponentDescription jaxwsHandlerDescription = WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, ejbEndpointName);
                        WSIntegrationProcessorJAXWS_HANDLER.propagateNamingContext(jaxwsHandlerDescription, ejbEndpoint);
                    }
                }
                continue;
            }
            for (POJOEndpoint pojoEndpoint : ASHelper.getJaxwsPojos(unit)) {
                if (!endpointClassName.equals(pojoEndpoint.getClassName())) continue;
                for (String handlerClassName : handlers) {
                    String pojoEndpointName = pojoEndpoint.getName();
                    handlerName = pojoEndpointName + "-" + handlerClassName;
                    WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, pojoEndpointName);
                }
            }
        }
    }

    private void registerConfigMapping(String endpointClassName, EndpointConfig config, DeploymentUnit unit) {
        WSEndpointConfigMapping mapping = (WSEndpointConfigMapping)unit.getAttachment(WSAttachmentKeys.WS_ENDPOINT_CONFIG_MAPPING_KEY);
        if (mapping == null) {
            mapping = new WSEndpointConfigMapping();
            unit.putAttachment(WSAttachmentKeys.WS_ENDPOINT_CONFIG_MAPPING_KEY, (Object)mapping);
        }
        mapping.registerEndpointConfig(endpointClassName, config);
    }

    private Set<String> getHandlers(String endpointClassName, EndpointConfig config, ConfigResolver resolver, WSEndpointHandlersMapping mapping) {
        Set<String> hch;
        Set handlers = resolver.getAllHandlers(config);
        if (mapping != null && (hch = mapping.getHandlers(endpointClassName)) != null) {
            handlers.addAll(hch);
        }
        return handlers;
    }

    private static void propagateNamingContext(ComponentDescription jaxwsHandlerDescription, EJBEndpoint ejbEndpoint) {
        ServiceName ejbContextServiceName = ejbEndpoint.getContextServiceName();
        DeploymentDescriptorEnvironment ejbEnv = ejbEndpoint.getDeploymentDescriptorEnvironment();
        jaxwsHandlerDescription.setContextServiceName(ejbContextServiceName);
        jaxwsHandlerDescription.setDeploymentDescriptorEnvironment(ejbEnv);
        jaxwsHandlerDescription.addDependency(ejbContextServiceName);
    }
}

