/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.completer;

import java.util.List;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.readline.util.Parser;

public class DefaultValueOptionCompleter
implements OptionCompleter<CompleterInvocation> {
    private final List<String> defaultValues;

    public DefaultValueOptionCompleter(List<String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Override
    public void complete(CompleterInvocation completerData) {
        this.completeDataWithoutValues(completerData);
        this.completeDataWithValues(completerData);
    }

    private void completeDataWithoutValues(CompleterInvocation completerData) {
        if (completerData.getGivenCompleteValue() == null || completerData.getGivenCompleteValue().length() == 0) {
            completerData.addAllCompleterValues(this.defaultValues);
            return;
        }
        for (String value : this.defaultValues) {
            if (!value.startsWith(completerData.getGivenCompleteValue())) continue;
            completerData.addCompleterValue(value);
        }
    }

    private void completeDataWithValues(CompleterInvocation completerData) {
        if (completerData.getCompleterValues().size() == 1 && completerData.getCompleterValues().get(0).containSpaces()) {
            String tmpData = Parser.switchSpacesToEscapedSpacesInWord(completerData.getCompleterValues().get(0).getCharacters());
            completerData.clearCompleterValues();
            completerData.addCompleterValue(tmpData);
            completerData.setAppendSpace(true);
        }
    }
}

