/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.EOFException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");
    public static final ElytronMessages tls = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.tls");

    @Message(id=2001, value="Invalid key store entry password for alias \"%s\"")
    public UnrecoverableKeyException invalidKeyStoreEntryPassword(String var1);

    @Message(id=2002, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public KeyStoreException invalidKeyStoreEntryType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=2003, value="Key store key for alias \"%s\" cannot be protected")
    public KeyStoreException keyCannotBeProtected(String var1);

    @Message(id=2004, value="Key store failed to translate password for alias \"%s\"")
    public IOException keyStoreFailedToTranslate(String var1, @Cause Throwable var2);

    @Message(id=2005, value="Key store failed to identify a suitable algorithm for alias \"%s\"")
    public NoSuchAlgorithmException noAlgorithmForPassword(String var1);

    @Message(id=2006, value="Unexpected whitespace in password file")
    public IOException unexpectedWhitespaceInPasswordFile();

    @Message(id=2007, value="Unexpected end of file")
    public EOFException unexpectedEof();

    @Message(id=2008, value="A reversible load is not possible until the KeyStore has first been initialized")
    public IllegalStateException reversibleLoadNotPossible();

    @Message(id=2009, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=2012, value="An empty alias filter was supplied")
    public IllegalArgumentException emptyFilter();

    @Message(id=2013, value="Filter is missing '+' or '-' at offset %d")
    public IllegalArgumentException missingPlusMinusAt(long var1);

    @Message(id=2014, value="Invalid first word '%s', must be one of ALL/NONE")
    public IllegalArgumentException invalidFirstWord(String var1);

    @Message(id=2015, value="Failed to obtain DirContext")
    public IllegalStateException failedToObtainDirContext(@Cause Throwable var1);

    @Message(id=2016, value="Failed to return DirContext")
    public IllegalStateException failedToReturnDirContext(@Cause Throwable var1);

    @Message(id=2017, value="LdapKeyStore failed to obtain alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainAlias(String var1, @Cause Throwable var2);

    @Message(id=2018, value="LdapKeyStore failed to obtain certificate [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificate(String var1, @Cause Throwable var2);

    @Message(id=2019, value="LdapKeyStore failed to obtain certificate chain [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(String var1, @Cause Throwable var2);

    @Message(id=2020, value="LdapKeyStore failed to recover key of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainKey(String var1, @Cause Throwable var2);

    @Message(id=2021, value="LdapKeyStore failed to obtain alias by certificate")
    public IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(@Cause Throwable var1);

    @Message(id=2022, value="LdapKeyStore failed to recover key of alias [%s]")
    public UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(String var1, @Cause Throwable var2);

    @Message(id=2023, value="LdapKeyStore failed to obtain creation date of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCreationDate(String var1, @Cause Throwable var2);

    @Message(id=2024, value="Alias [%s] does not exist in LdapKeyStore and not configured for creation")
    public KeyStoreException creationNotConfigured(String var1);

    @Message(id=2025, value="LdapKeyStore failed store alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToStore(String var1, @Cause Throwable var2);

    @Message(id=2026, value="LdapKeyStore failed to serialize certificate of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeCertificate(String var1, @Cause Throwable var2);

    @Message(id=2027, value="LdapKeyStore failed to protect (pack into keystore) key of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeKey(String var1, @Cause Throwable var2);

    @Message(id=2028, value="LdapKeyStore failed to delete alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToDelete(String var1, @Cause Throwable var2);

    @Message(id=2029, value="LdapKeyStore failed to delete alias [%s] - alias not found")
    public KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(String var1);

    @Message(id=2030, value="LdapKeyStore failed to test alias [%s] existence")
    public IllegalStateException ldapKeyStoreFailedToTestAliasExistence(String var1, @Cause Throwable var2);

    @Message(id=2031, value="LdapKeyStore failed to iterate aliases")
    public IllegalStateException ldapKeyStoreFailedToIterateAliases(@Cause Throwable var1);

    @Message(id=2035, value="KeyStore type could not be detected")
    public KeyStoreException keyStoreTypeNotDetected();

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();
}

