/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.OriginTrackedMetadata;
import io.smallrye.metrics.app.CounterImpl;
import io.smallrye.metrics.app.ExponentiallyDecayingReservoir;
import io.smallrye.metrics.app.HistogramImpl;
import io.smallrye.metrics.app.MeterImpl;
import io.smallrye.metrics.app.TimerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;

@Vetoed
public class MetricsRegistryImpl
extends MetricRegistry {
    private static final Logger log = Logger.getLogger(MetricsRegistryImpl.class);
    private Map<String, Metadata> metadataMap = new HashMap<String, Metadata>();
    private Map<String, Metric> metricMap = new ConcurrentHashMap<String, Metric>();

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        MetricType type;
        if (this.metricMap.keySet().contains(name)) {
            throw new IllegalArgumentException("A metric with name " + name + " already exists");
        }
        Class<?> metricCls = metric.getClass();
        if (metricCls.getName().contains("Lambda")) {
            String tname = metricCls.getGenericInterfaces()[0].getTypeName();
            tname = tname.substring(tname.lastIndexOf(46) + 1);
            tname = tname.toLowerCase();
            type = MetricType.from((String)tname);
        } else {
            type = metricCls.isAnonymousClass() ? MetricType.from(metricCls.getInterfaces().length == 0 ? metricCls.getSuperclass().getInterfaces()[0] : metricCls.getInterfaces()[0]) : (!metricCls.isInterface() ? MetricType.from(metricCls.getInterfaces()[0]) : MetricType.from(metricCls));
        }
        Metadata m = new Metadata(name, type);
        this.metricMap.put(name, metric);
        this.metadataMap.put(name, m);
        return metric;
    }

    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        metadata.setName(name);
        return this.register(metadata, metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        boolean reusableFlag;
        String name = metadata.getName();
        if (name == null) {
            throw new IllegalArgumentException("Metric name must not be null");
        }
        Metadata existingMetadata = this.metadataMap.get(name);
        boolean bl = reusableFlag = existingMetadata == null || existingMetadata.isReusable();
        if (metadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            reusableFlag = false;
        }
        if (this.metricMap.keySet().contains(metadata.getName()) && !reusableFlag) {
            throw new IllegalArgumentException("A metric with name " + metadata.getName() + " already exists");
        }
        if (existingMetadata != null && !existingMetadata.getTypeRaw().equals((Object)metadata.getTypeRaw())) {
            throw new IllegalArgumentException("Passed metric type does not match existing type");
        }
        if (existingMetadata != null && existingMetadata.isReusable() != metadata.isReusable()) {
            throw new IllegalArgumentException("Reusable flag differs from previous usage");
        }
        this.metricMap.put(name, metric);
        this.metadataMap.put(name, this.duplicate(metadata));
        return metric;
    }

    protected Metadata duplicate(Metadata meta) {
        Metadata copy = null;
        copy = meta instanceof OriginTrackedMetadata ? new OriginTrackedMetadata(((OriginTrackedMetadata)meta).getOrigin(), meta.getName(), meta.getTypeRaw()) : new Metadata(meta.getName(), meta.getTypeRaw());
        copy.setDescription(meta.getDescription());
        copy.setUnit(meta.getUnit());
        copy.setDisplayName(meta.getDisplayName());
        copy.setReusable(meta.isReusable());
        HashMap tagsCopy = new HashMap();
        tagsCopy.putAll(meta.getTags());
        copy.setTags(tagsCopy);
        return copy;
    }

    public Counter counter(String name) {
        return this.counter(new Metadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return (Counter)this.get(metadata, MetricType.COUNTER);
    }

    public Histogram histogram(String name) {
        return this.histogram(new Metadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.get(metadata, MetricType.HISTOGRAM);
    }

    public Meter meter(String s) {
        return this.meter(new Metadata(s, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return (Meter)this.get(metadata, MetricType.METERED);
    }

    private <T extends Metric> T get(Metadata metadata, MetricType type) {
        String name = metadata.getName();
        log.debugf("Get metric [name: %s, type: %s]", (Object)name, (Object)type);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        Metadata previous = this.metadataMap.get(name);
        if (previous == null) {
            Object m;
            switch (type) {
                case COUNTER: {
                    m = new CounterImpl();
                    break;
                }
                case GAUGE: {
                    throw new IllegalArgumentException("Gauge " + name + " was not registered, this should not happen");
                }
                case METERED: {
                    m = new MeterImpl();
                    break;
                }
                case HISTOGRAM: {
                    m = new HistogramImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case TIMER: {
                    m = new TimerImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not happen");
                }
            }
            log.infof("Register metric [name: %s, type: %s]", (Object)name, (Object)type);
            this.register(metadata, m);
        } else {
            if (!previous.getTypeRaw().equals((Object)metadata.getTypeRaw())) {
                throw new IllegalArgumentException("Previously registered metric " + name + " is of type " + previous.getType() + ", expected " + metadata.getType());
            }
            if (!this.haveCompatibleOrigins(previous, metadata)) {
                if (previous.isReusable() && !metadata.isReusable()) {
                    throw new IllegalArgumentException("Previously registered metric " + name + " was flagged as reusable, while current request is not.");
                }
                if (!previous.isReusable()) {
                    throw new IllegalArgumentException("Previously registered metric " + name + " was not flagged as reusable");
                }
            }
        }
        return (T)this.metricMap.get(name);
    }

    private boolean haveCompatibleOrigins(Metadata left, Metadata right) {
        if (left instanceof OriginTrackedMetadata && right instanceof OriginTrackedMetadata) {
            OriginTrackedMetadata leftOrigin = (OriginTrackedMetadata)left;
            OriginTrackedMetadata rightOrigin = (OriginTrackedMetadata)right;
            if (leftOrigin.getOrigin().equals(rightOrigin.getOrigin())) {
                return true;
            }
            if (leftOrigin.getOrigin() instanceof InjectionPoint || ((OriginTrackedMetadata)right).getOrigin() instanceof InjectionPoint) {
                return true;
            }
        }
        return false;
    }

    public Timer timer(String s) {
        return this.timer(new Metadata(s, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return (Timer)this.get(metadata, MetricType.TIMER);
    }

    public boolean remove(String metricName) {
        if (this.metricMap.containsKey(metricName)) {
            log.debugf("Remove metric [name: %s]", (Object)metricName);
            this.metricMap.remove(metricName);
            this.metadataMap.remove(metricName);
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<String, Metric> entry : this.metricMap.entrySet()) {
            if (!metricFilter.matches(entry.getKey(), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metricMap.keySet());
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public Map<String, Metric> getMetrics() {
        return new HashMap<String, Metric>(this.metricMap);
    }

    private <T extends Metric> SortedMap<String, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<String, Metric> out = new TreeMap<String, Metric>();
        for (Map.Entry<String, Metric> entry : this.metricMap.entrySet()) {
            Metadata metadata = this.metadataMap.get(entry.getKey());
            if (metadata.getTypeRaw() != type || !filter.matches(entry.getKey(), entry.getValue())) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public Map<String, Metadata> getMetadata() {
        return new HashMap<String, Metadata>(this.metadataMap);
    }
}

