/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;

public class RecoveryAwareGlobalTransaction
extends GlobalTransaction
implements RecoverableTransactionIdentifier {
    private volatile Xid xid;
    private volatile long internalId;

    public RecoveryAwareGlobalTransaction() {
    }

    public RecoveryAwareGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void setXid(Xid xid) {
        this.xid = xid;
    }

    @Override
    public long getInternalId() {
        return this.internalId;
    }

    @Override
    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{xid=" + this.xid + ", internalId=" + this.internalId + "} " + super.toString();
    }

    public static class Externalizer
    extends GlobalTransaction.AbstractGlobalTxExternalizer<RecoveryAwareGlobalTransaction> {
        @Override
        protected RecoveryAwareGlobalTransaction createGlobalTransaction() {
            return (RecoveryAwareGlobalTransaction)TransactionFactory.TxFactoryEnum.NODLD_RECOVERY_XA.newGlobalTransaction();
        }

        @Override
        public void writeObject(ObjectOutput output, RecoveryAwareGlobalTransaction xidGtx) throws IOException {
            super.writeObject(output, xidGtx);
            output.writeObject(xidGtx.xid);
            output.writeLong(xidGtx.getInternalId());
        }

        @Override
        public RecoveryAwareGlobalTransaction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            RecoveryAwareGlobalTransaction xidGtx = (RecoveryAwareGlobalTransaction)super.readObject(input);
            Xid xid = (Xid)input.readObject();
            xidGtx.setXid(xid);
            xidGtx.setInternalId(input.readLong());
            return xidGtx;
        }

        public Integer getId() {
            return 34;
        }

        public Set<Class<? extends RecoveryAwareGlobalTransaction>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RecoveryAwareGlobalTransaction.class});
        }
    }
}

