/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

class SystemPropertiesXml {
    SystemPropertiesXml() {
    }

    void parseSystemProperties(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> updates, boolean standalone) throws XMLStreamException {
        Properties properties = WildFlySecurityManager.getSystemPropertiesPrivileged();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            boolean setName = false;
            boolean setValue = false;
            boolean setBoottime = false;
            ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)new ModelNode());
            int count = reader.getAttributeCount();
            String name = null;
            block15: for (int i = 0; i < count; ++i) {
                String attribute;
                String val = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                switch (attribute = reader.getAttributeLocalName(i)) {
                    case "name": {
                        if (setName) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"name");
                        }
                        setName = true;
                        ModelNode addr = new ModelNode().set(address).add("system-property", val);
                        op.get("address").set(addr);
                        name = val;
                        continue block15;
                    }
                    case "value": {
                        if (setValue) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"value");
                        }
                        setValue = true;
                        SystemPropertyResourceDefinition.VALUE.parseAndSetParameter(val, op, (XMLStreamReader)reader);
                        continue block15;
                    }
                    case "boot-time": {
                        if (standalone) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        if (setBoottime) {
                            throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)"boot-time");
                        }
                        setBoottime = true;
                        SystemPropertyResourceDefinition.BOOT_TIME.parseAndSetParameter(val, op, (XMLStreamReader)reader);
                        continue block15;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (!setName) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
            }
            try {
                String newPropertyValue = SystemPropertyResourceDefinition.VALUE.resolveValue(ExpressionResolver.SIMPLE, op.get("value")).asString();
                String oldPropertyValue = properties.getProperty(name);
                if (oldPropertyValue != null && !oldPropertyValue.equals(newPropertyValue)) {
                    ControllerLogger.ROOT_LOGGER.systemPropertyAlreadyExist(name, oldPropertyValue, newPropertyValue);
                }
            }
            catch (OperationFailedException e) {
                ServerLogger.AS_ROOT_LOGGER.tracef(e, "Failed to resolve value for system property %s at parse time.", name);
            }
            if (standalone) {
                try {
                    System.setProperty(name, SystemPropertyResourceDefinition.VALUE.resolveValue(ExpressionResolver.SIMPLE, op.get("value")).asString());
                }
                catch (OperationFailedException e) {
                    ServerLogger.AS_ROOT_LOGGER.tracef(e, "Failed to set property %s at parse time, it will be set later in the boot process", name);
                }
            }
            updates.add(op);
        }
    }

    void writeProperties(XMLExtendedStreamWriter writer, ModelNode modelNode, Element element, boolean standalone) throws XMLStreamException {
        List properties = modelNode.asPropertyList();
        if (properties.size() > 0) {
            writer.writeStartElement(element.getLocalName());
            for (Property prop : properties) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute("name", prop.getName());
                ModelNode sysProp = prop.getValue();
                SystemPropertyResourceDefinition.VALUE.marshallAsAttribute(sysProp, (XMLStreamWriter)writer);
                if (!standalone) {
                    SystemPropertyResourceDefinition.BOOT_TIME.marshallAsAttribute(sysProp, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

