/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngineBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.VerifierWrapper;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.engines.PassthroughTrustManager;
import org.jboss.resteasy.client.jaxrs.engines.factory.ApacheHttpClient4EngineFactory;

public class ClientHttpEngineBuilder43
implements ClientHttpEngineBuilder {
    private ResteasyClientBuilder that;

    @Override
    public ClientHttpEngineBuilder resteasyClientBuilder(ResteasyClientBuilder resteasyClientBuilder) {
        this.that = resteasyClientBuilder;
        return this;
    }

    @Override
    public ClientHttpEngine build() {
        VerifierWrapper verifier = null;
        if (this.that.verifier != null) {
            verifier = new VerifierWrapper(this.that.verifier);
        } else {
            switch (this.that.policy) {
                case ANY: {
                    verifier = new NoopHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new DefaultHostnameVerifier();
                    break;
                }
                case STRICT: {
                    verifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
                }
            }
        }
        try {
            SSLConnectionSocketFactory sslsf = null;
            SSLContext theContext = this.that.sslContext;
            if (this.that.disableTrustManager) {
                theContext = SSLContext.getInstance("SSL");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new NoopHostnameVerifier();
                sslsf = new SSLConnectionSocketFactory(theContext, (HostnameVerifier)((Object)verifier));
            } else if (theContext != null) {
                sslsf = new SSLConnectionSocketFactory(theContext, (HostnameVerifier)((Object)verifier)){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        if (!((ClientHttpEngineBuilder43)ClientHttpEngineBuilder43.this).that.sniHostNames.isEmpty()) {
                            ArrayList<SNIServerName> sniNames = new ArrayList<SNIServerName>(((ClientHttpEngineBuilder43)ClientHttpEngineBuilder43.this).that.sniHostNames.size());
                            for (String sniHostName : ((ClientHttpEngineBuilder43)ClientHttpEngineBuilder43.this).that.sniHostNames) {
                                sniNames.add(new SNIHostName(sniHostName));
                            }
                            SSLParameters sslParameters = socket.getSSLParameters();
                            sslParameters.setServerNames(sniNames);
                            socket.setSSLParameters(sslParameters);
                        }
                    }
                };
            } else if (this.that.clientKeyStore != null || this.that.truststore != null) {
                SSLContext ctx = SSLContexts.custom().useProtocol("TLS").setSecureRandom(null).loadKeyMaterial(this.that.clientKeyStore, this.that.clientPrivateKeyPassword != null ? this.that.clientPrivateKeyPassword.toCharArray() : null).loadTrustMaterial(this.that.truststore, (TrustStrategy)(this.that.isTrustSelfSignedCertificates() ? TrustSelfSignedStrategy.INSTANCE : null)).build();
                sslsf = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)((Object)verifier)){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        ClientHttpEngineBuilder43.this.that.prepareSocketForSni(socket);
                    }
                };
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslsf = new SSLConnectionSocketFactory(tlsContext, (HostnameVerifier)((Object)verifier));
            }
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            BasicHttpClientConnectionManager cm = null;
            if (this.that.connectionPoolSize > 0) {
                PoolingHttpClientConnectionManager tcm = new PoolingHttpClientConnectionManager(registry, null, null, null, this.that.connectionTTL, this.that.connectionTTLUnit);
                tcm.setMaxTotal(this.that.connectionPoolSize);
                if (this.that.maxPooledPerRoute == 0) {
                    this.that.maxPooledPerRoute = this.that.connectionPoolSize;
                }
                tcm.setDefaultMaxPerRoute(this.that.maxPooledPerRoute);
                cm = tcm;
            } else {
                cm = new BasicHttpClientConnectionManager((Lookup)registry);
            }
            RequestConfig.Builder rcBuilder = RequestConfig.custom();
            if (this.that.socketTimeout > -1L) {
                rcBuilder.setSocketTimeout((int)this.that.socketTimeoutUnits.toMillis(this.that.socketTimeout));
            }
            if (this.that.establishConnectionTimeout > -1L) {
                rcBuilder.setConnectTimeout((int)this.that.establishConnectionTimeoutUnits.toMillis(this.that.establishConnectionTimeout));
            }
            if (this.that.connectionCheckoutTimeoutMs > -1) {
                rcBuilder.setConnectionRequestTimeout(this.that.connectionCheckoutTimeoutMs);
            }
            return this.createEngine((HttpClientConnectionManager)cm, rcBuilder, this.that.defaultProxy, this.that.responseBufferSize, (HostnameVerifier)((Object)verifier), theContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ClientHttpEngine createEngine(final HttpClientConnectionManager cm, final RequestConfig.Builder rcBuilder, final HttpHost defaultProxy, int responseBufferSize, HostnameVerifier verifier, SSLContext theContext) {
        Object httpClient = System.getSecurityManager() == null ? HttpClientBuilder.create().setConnectionManager(cm).setDefaultRequestConfig(rcBuilder.build()).setProxy(defaultProxy).disableContentCompression().build() : AccessController.doPrivileged(new PrivilegedAction<HttpClient>(){

            @Override
            public HttpClient run() {
                return HttpClientBuilder.create().setConnectionManager(cm).setDefaultRequestConfig(rcBuilder.build()).setProxy(defaultProxy).disableContentCompression().build();
            }
        });
        ApacheHttpClient43Engine engine = (ApacheHttpClient43Engine)ApacheHttpClient4EngineFactory.create(httpClient, true);
        engine.setResponseBufferSize(responseBufferSize);
        engine.setHostnameVerifier(verifier);
        engine.setSslContext(theContext);
        return engine;
    }
}

