/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonbPropertyInfo;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class Marshaller
extends ProcessingContext
implements SerializationContext {
    private static final Logger logger = Logger.getLogger(Marshaller.class.getName());
    private Type runtimeType;

    public Marshaller(JsonbContext jsonbContext, Type rootRuntimeType) {
        super(jsonbContext);
        this.runtimeType = rootRuntimeType;
    }

    public Marshaller(JsonbContext jsonbContext) {
        super(jsonbContext);
        this.runtimeType = null;
    }

    public void marshall(Object object, JsonGenerator jsonGenerator) {
        try {
            ClassModel classModel = this.getMappingContext().getOrCreateClassModel(object.getClass());
            this.serializeRoot(object, jsonGenerator, classModel);
        }
        catch (JsonbException e) {
            logger.severe(e.getMessage());
            throw e;
        }
        finally {
            try {
                jsonGenerator.close();
            }
            catch (JsonGenerationException jge) {
                logger.severe(jge.getMessage());
            }
        }
    }

    public <T> void serialize(String key, T object, JsonGenerator generator) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(object);
        ClassModel classModel = this.getMappingContext().getOrCreateClassModel(object.getClass());
        generator.writeKey(key);
        this.serializeRoot(object, generator, classModel);
    }

    public <T> void serialize(T object, JsonGenerator generator) {
        Objects.requireNonNull(object);
        ClassModel classModel = this.getMappingContext().getOrCreateClassModel(object.getClass());
        this.serializeRoot(object, generator, classModel);
    }

    public <T> void serializeRoot(T root, JsonGenerator generator, ClassModel classModel) {
        JsonbSerializer<?> rootSerializer = this.getRootSerializer(root.getClass(), classModel);
        if (this.jsonbContext.getConfigProperties().isStrictIJson() && rootSerializer instanceof AbstractValueTypeSerializer) {
            throw new JsonbException(Messages.getMessage(MessageKeys.IJSON_ENABLED_SINGLE_VALUE, new Object[0]));
        }
        rootSerializer.serialize(root, generator, (SerializationContext)this);
    }

    private JsonbSerializer<?> getRootSerializer(Class<?> rootClazz, ClassModel classModel) {
        ContainerSerializerProvider serializerProvider = this.getMappingContext().getSerializerProvider(rootClazz);
        if (serializerProvider != null) {
            return serializerProvider.provideSerializer(new JsonbPropertyInfo().withRuntimeType(this.runtimeType).withClassModel(classModel));
        }
        return ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(this.jsonbContext).withObjectClass(rootClazz).withType(this.runtimeType)).withCustomization(classModel.getCustomization())).build();
    }
}

