/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.app.HistogramImpl;
import io.smallrye.metrics.app.MeterImpl;
import io.smallrye.metrics.app.TimerImpl;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.ExporterUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.jboss.logging.Logger;

public class JsonExporter
implements Exporter {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final String COMMA_LF = ",\n";
    private static final String LF = "\n";

    @Override
    public StringBuffer exportOneScope(MetricRegistry.Type scope) {
        StringBuffer sb = new StringBuffer();
        this.getMetricsForAScope(sb, scope);
        return sb;
    }

    private void getMetricsForAScope(StringBuffer sb, MetricRegistry.Type scope) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        sb.append("{\n");
        this.writeMetricsForMap(sb, metricMap, metadataMap);
        sb.append(LF).append("}");
    }

    private void writeMetricsForMap(StringBuffer sb, Map<String, Metric> metricMap, Map<String, Metadata> metadataMap) {
        boolean first = true;
        for (Map.Entry<String, Metric> entry : metricMap.entrySet()) {
            String key = entry.getKey();
            Metric value = entry.getValue();
            Metadata metadata = metadataMap.get(key);
            if (metadata == null) {
                throw new IllegalArgumentException("MD is null for " + key);
            }
            StringBuffer metricBuffer = new StringBuffer();
            if (first) {
                first = false;
            } else {
                metricBuffer.append(',').append(LF);
            }
            try {
                switch (metadata.getTypeRaw()) {
                    case GAUGE: 
                    case COUNTER: {
                        Number val = this.getValueFromMetric(value, key);
                        metricBuffer.append("  ").append('\"').append(key).append('\"').append(" : ").append(val);
                        break;
                    }
                    case METERED: {
                        MeterImpl meter = (MeterImpl)value;
                        this.writeStartLine(metricBuffer, key);
                        this.writeMeterValues(metricBuffer, (Metered)meter);
                        this.writeEndLine(metricBuffer);
                        break;
                    }
                    case TIMER: {
                        TimerImpl timer = (TimerImpl)value;
                        this.writeStartLine(metricBuffer, key);
                        this.writeTimerValues(metricBuffer, timer, metadata.getUnit());
                        this.writeEndLine(metricBuffer);
                        break;
                    }
                    case HISTOGRAM: {
                        HistogramImpl hist = (HistogramImpl)value;
                        this.writeStartLine(metricBuffer, key);
                        metricBuffer.append("    \"count\": ").append(hist.getCount()).append(COMMA_LF);
                        this.writeSnapshotValues(metricBuffer, hist.getSnapshot());
                        this.writeEndLine(metricBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported: " + key);
                    }
                }
                sb.append(metricBuffer);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to export metric " + key), (Throwable)e);
            }
        }
    }

    private void writeEndLine(StringBuffer sb) {
        sb.append("  }");
    }

    private void writeStartLine(StringBuffer sb, String key) {
        sb.append("  ").append('\"').append(key).append('\"').append(" : ").append("{\n");
    }

    private void writeMeterValues(StringBuffer sb, Metered meter) {
        sb.append("    \"count\": ").append(meter.getCount()).append(COMMA_LF);
        sb.append("    \"meanRate\": ").append(meter.getMeanRate()).append(COMMA_LF);
        sb.append("    \"oneMinRate\": ").append(meter.getOneMinuteRate()).append(COMMA_LF);
        sb.append("    \"fiveMinRate\": ").append(meter.getFiveMinuteRate()).append(COMMA_LF);
        sb.append("    \"fifteenMinRate\": ").append(meter.getFifteenMinuteRate()).append(LF);
    }

    private void writeTimerValues(StringBuffer sb, TimerImpl timer, String unit) {
        this.writeSnapshotValues(sb, timer.getSnapshot(), unit);
        sb.setLength(sb.length() - 1);
        sb.append(COMMA_LF);
        this.writeMeterValues(sb, timer.getMeter());
    }

    private void writeSnapshotValues(StringBuffer sb, Snapshot snapshot) {
        sb.append("    \"p50\": ").append(snapshot.getMedian()).append(COMMA_LF);
        sb.append("    \"p75\": ").append(snapshot.get75thPercentile()).append(COMMA_LF);
        sb.append("    \"p95\": ").append(snapshot.get95thPercentile()).append(COMMA_LF);
        sb.append("    \"p98\": ").append(snapshot.get98thPercentile()).append(COMMA_LF);
        sb.append("    \"p99\": ").append(snapshot.get99thPercentile()).append(COMMA_LF);
        sb.append("    \"p999\": ").append(snapshot.get999thPercentile()).append(COMMA_LF);
        sb.append("    \"min\": ").append(snapshot.getMin()).append(COMMA_LF);
        sb.append("    \"mean\": ").append(snapshot.getMean()).append(COMMA_LF);
        sb.append("    \"max\": ").append(snapshot.getMax()).append(COMMA_LF);
        sb.append("    \"stddev\": ").append(snapshot.getStdDev()).append(LF);
    }

    private void writeSnapshotValues(StringBuffer sb, Snapshot snapshot, String unit) {
        sb.append("    \"p50\": ").append(this.toBase(snapshot.getMedian(), unit)).append(COMMA_LF);
        sb.append("    \"p75\": ").append(this.toBase(snapshot.get75thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p95\": ").append(this.toBase(snapshot.get95thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p98\": ").append(this.toBase(snapshot.get98thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p99\": ").append(this.toBase(snapshot.get99thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p999\": ").append(this.toBase(snapshot.get999thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"min\": ").append(this.toBase(snapshot.getMin(), unit)).append(COMMA_LF);
        sb.append("    \"mean\": ").append(this.toBase(snapshot.getMean(), unit)).append(COMMA_LF);
        sb.append("    \"max\": ").append(this.toBase(snapshot.getMax(), unit)).append(COMMA_LF);
        sb.append("    \"stddev\": ").append(this.toBase(snapshot.getStdDev(), unit)).append(LF);
    }

    private Number toBase(Number count, String unit) {
        return ExporterUtil.convertNanosTo(count.doubleValue(), unit);
    }

    private Number getValueFromMetric(Metric theMetric, String name) {
        if (theMetric instanceof Gauge) {
            Number value = (Number)((Gauge)theMetric).getValue();
            if (value != null) {
                return value;
            }
            log.warn((Object)("Value is null for " + name));
            return -142.142;
        }
        if (theMetric instanceof Counter) {
            return ((Counter)theMetric).getCount();
        }
        log.error((Object)("Not yet supported metric: " + theMetric.getClass().getName()));
        return -42.42;
    }

    @Override
    public StringBuffer exportAllScopes() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (MetricRegistry.Type scope : MetricRegistry.Type.values()) {
            MetricRegistry registry = MetricRegistries.get(scope);
            if (registry.getNames().size() <= 0) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append('\"').append(scope.getName().toLowerCase()).append('\"').append(" :\n");
            this.getMetricsForAScope(sb, scope);
            sb.append(LF);
            first = false;
        }
        sb.append("}");
        return sb;
    }

    @Override
    public StringBuffer exportOneMetric(MetricRegistry.Type scope, String metricName) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        Metric m = (Metric)metricMap.get(metricName);
        HashMap<String, Metric> outMap = new HashMap<String, Metric>(1);
        outMap.put(metricName, m);
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        this.writeMetricsForMap(sb, outMap, metadataMap);
        sb.append("}");
        sb.append(LF);
        return sb;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

