/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.runtime.parser.node.MathUtils;

public class DuckType {
    protected static final Object NO_METHOD = new Object();

    public static String asString(Object object) {
        return DuckType.asString(object, true);
    }

    public static String asString(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        Object object2 = DuckType.get(object, Types.STRING);
        if (object2 == NO_METHOD) {
            return bl ? object.toString() : null;
        }
        return (String)object2;
    }

    public static boolean asNull(Object object) {
        return object == null || DuckType.get(object, Types.STRING) == null || DuckType.get(object, Types.NUMBER) == null;
    }

    public static boolean asBoolean(Object object, boolean bl) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        Object object2 = DuckType.get(object, Types.BOOLEAN);
        if (object2 != NO_METHOD) {
            return (Boolean)object2;
        }
        if (bl) {
            return !DuckType.asEmpty(object);
        }
        return true;
    }

    public static boolean asEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        Object object2 = DuckType.get(object, Types.EMPTY);
        if (object2 != NO_METHOD) {
            return (Boolean)object2;
        }
        Object object3 = DuckType.get(object, Types.LENGTH);
        if (object3 != NO_METHOD && object3 instanceof Number) {
            return MathUtils.isZero((Number)object3);
        }
        Object object4 = DuckType.get(object, Types.SIZE);
        if (object4 != NO_METHOD && object4 instanceof Number) {
            return MathUtils.isZero((Number)object4);
        }
        if (object instanceof Number) {
            return MathUtils.isZero((Number)object);
        }
        Object object5 = DuckType.get(object, Types.STRING);
        if (object5 == null) {
            return true;
        }
        if (object5 != NO_METHOD) {
            return ((String)object5).length() == 0;
        }
        Object object6 = DuckType.get(object, Types.NUMBER);
        if (object6 == null) {
            return true;
        }
        if (object6 != NO_METHOD && object6 instanceof Number) {
            return MathUtils.isZero((Number)object6);
        }
        return false;
    }

    public static Number asNumber(Object object) {
        return DuckType.asNumber(object, true);
    }

    public static Number asNumber(Object object, boolean bl) {
        String string;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        Object object2 = DuckType.get(object, Types.NUMBER);
        if (object2 != NO_METHOD) {
            return (Number)object2;
        }
        if (bl && (string = DuckType.asString(object)) != null) {
            return new BigDecimal(string);
        }
        return null;
    }

    protected static Object get(Object object, Types types) {
        try {
            Class<?> clazz = object.getClass();
            Object object2 = types.get(clazz);
            if (object2 == NO_METHOD) {
                return object2;
            }
            if (object2 != null) {
                return ((Method)object2).invoke(object, new Object[0]);
            }
            Method method = DuckType.findMethod(clazz, types);
            if (method == null) {
                types.set(clazz, NO_METHOD);
                return NO_METHOD;
            }
            types.set(clazz, method);
            return method.invoke(object, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected static Method findMethod(Class clazz, Types types) {
        if (clazz == null || clazz == Object.class) {
            return null;
        }
        Method method = DuckType.getMethod(clazz, types.name);
        if (method != null) {
            return method;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            method = DuckType.findMethod(clazz2, types);
            if (method == null) continue;
            return method;
        }
        method = DuckType.findMethod(clazz.getSuperclass(), types);
        if (method != null) {
            return method;
        }
        return null;
    }

    private static Method getMethod(Class clazz, String string) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method method = clazz.getDeclaredMethod(string, new Class[0]);
                if (Modifier.isPublic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static enum Types {
        STRING("getAsString"),
        NUMBER("getAsNumber"),
        BOOLEAN("getAsBoolean"),
        EMPTY("isEmpty"),
        LENGTH("length"),
        SIZE("size");

        final String name;
        final Map<Class, Object> cache = new HashMap<Class, Object>();

        private Types(String string2) {
            this.name = string2;
        }

        void set(Class clazz, Object object) {
            this.cache.put(clazz, object);
        }

        Object get(Class clazz) {
            return this.cache.get(clazz);
        }
    }
}

