/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIBean<T>
implements Bean<T>,
PassivationCapable {
    private final Set<Annotation> qualifiers;
    private final String name;
    private final Class<? extends T> type;
    private final Class<? extends Annotation> scope;

    public JNDIBean(String name, Class<? extends T> type, Class<? extends Annotation> scope) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.scope = scope == null ? Dependent.class : scope;
        this.qualifiers = new HashSet<Annotation>();
        this.qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        this.qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
    }

    public final T create(CreationalContext<T> cc) {
        Context initialContext = null;
        CreationException e = null;
        try {
            initialContext = this.getNewInitialContext();
            T t = this.type.cast(initialContext.lookup(this.name));
            return t;
        }
        catch (NamingException namingException) {
            e = new CreationException(namingException.getMessage(), (Throwable)namingException);
            throw e;
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    if (e != null) {
                        e.addSuppressed((Throwable)namingException);
                    } else {
                        e = new CreationException(namingException.getMessage(), (Throwable)namingException);
                    }
                    throw e;
                }
            }
        }
    }

    public void destroy(T instance, CreationalContext<T> cc) {
        if (cc != null) {
            cc.release();
        }
    }

    public Class<?> getBeanClass() {
        return this.getClass();
    }

    public String getId() {
        String COMMA = ",";
        String CLASS_DELIMITER = "%";
        return this.getBeanClass().getName() + "%" + this.getName() + "," + this.getScope().getName() + "," + this.isAlternative() + "," + this.getQualifiers() + "," + this.getStereotypes() + "," + this.getTypes();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getName() {
        return null;
    }

    protected Context getNewInitialContext() throws NamingException {
        return new InitialContext();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public final Set<Type> getTypes() {
        return Collections.singleton(this.type);
    }

    public final Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public boolean isAlternative() {
        return false;
    }

    public final boolean isNullable() {
        return false;
    }

    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final Default INSTANCE = new DefaultLiteral();

        private DefaultLiteral() {
        }
    }

    private static final class AnyLiteral
    extends AnnotationLiteral<Any>
    implements Any {
        private static final Any INSTANCE = new AnyLiteral();

        private AnyLiteral() {
        }
    }
}

