/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.security.wss4j.UsernameTokenInterceptor;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.i18n.Loggers;
import org.jboss.wsf.stack.cxf.i18n.Messages;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreator;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreatingPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected final SubjectCreator helper = new SubjectCreator();

    public SubjectCreatingPolicyInterceptor() {
        this("pre-protocol");
        this.addAfter(UsernameTokenInterceptor.class.getName());
    }

    public SubjectCreatingPolicyInterceptor(String phase) {
        super(phase);
        this.helper.setPropagateContext(true);
    }

    public void handleMessage(Message message) throws Fault {
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        SecurityDomainContext sdc = ep.getSecurityDomainContext();
        SecurityContext context = (SecurityContext)message.get(SecurityContext.class);
        if (context == null || context.getUserPrincipal() == null) {
            Loggers.SECURITY_LOGGER.userPrincipalNotAvailableOnCurrentMessage();
            return;
        }
        SecurityToken token = (SecurityToken)message.get(SecurityToken.class);
        Subject subject = null;
        if (token != null) {
            if (token.getTokenType() != TokenType.UsernameToken) {
                throw Messages.MESSAGES.unsupportedTokenType((Object)token.getTokenType());
            }
            UsernameToken ut = (UsernameToken)token;
            subject = this.createSubject(sdc, ut.getName(), ut.getPassword(), ut.isHashed(), ut.getNonce(), ut.getCreatedTime());
        } else {
            Principal p = context.getUserPrincipal();
            if (!(p instanceof UsernameTokenPrincipal)) {
                throw Messages.MESSAGES.couldNotGetSubjectInfo();
            }
            UsernameTokenPrincipal up = (UsernameTokenPrincipal)p;
            subject = this.createSubject(sdc, up.getName(), up.getPassword(), up.isPasswordDigest(), up.getNonce(), up.getCreatedTime());
        }
        Principal principal = this.getPrincipal(context.getUserPrincipal(), subject);
        message.put(SecurityContext.class, (Object)this.createSecurityContext(principal, subject));
    }

    protected Subject createSubject(SecurityDomainContext sdc, String name, String password, boolean isDigest, String nonce, String creationTime) {
        Subject subject = null;
        try {
            subject = this.helper.createSubject(sdc, name, password, isDigest, nonce, creationTime);
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.authenticationFailedSubjectNotCreated((Throwable)ex);
        }
        if (subject == null || subject.getPrincipals().size() == 0) {
            throw Messages.MESSAGES.authenticationFailedSubjectInvalid();
        }
        return subject;
    }

    protected Subject createSubject(SecurityDomainContext sdc, String name, String password, boolean isDigest, byte[] nonce, String creationTime) {
        Subject subject = null;
        try {
            subject = this.helper.createSubject(sdc, name, password, isDigest, nonce, creationTime);
        }
        catch (Exception ex) {
            throw Messages.MESSAGES.authenticationFailedSubjectNotCreated((Throwable)ex);
        }
        if (subject == null || subject.getPrincipals().size() == 0) {
            throw Messages.MESSAGES.authenticationFailedSubjectInvalid();
        }
        return subject;
    }

    protected Principal getPrincipal(Principal originalPrincipal, Subject subject) {
        Principal principal;
        Set<Principal> principals = subject.getPrincipals();
        if (!principals.isEmpty() && !((principal = principals.iterator().next()) instanceof Group)) {
            return principal;
        }
        return originalPrincipal;
    }

    protected SecurityContext createSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    public void setPropagateContext(boolean propagateContext) {
        this.helper.setPropagateContext(propagateContext);
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.helper.setTimestampThreshold(timestampThreshold);
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.helper.setNonceStore(nonceStore);
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.helper.setDecodeNonce(decodeNonce);
    }
}

