/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.attribute.AuthenticationTypeExchangeAttribute;
import io.undertow.attribute.BytesSentAttribute;
import io.undertow.attribute.DateTimeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.HostAndPortAttribute;
import io.undertow.attribute.LocalIPAttribute;
import io.undertow.attribute.LocalPortAttribute;
import io.undertow.attribute.LocalServerNameAttribute;
import io.undertow.attribute.PathParameterAttribute;
import io.undertow.attribute.PredicateContextAttribute;
import io.undertow.attribute.QueryParameterAttribute;
import io.undertow.attribute.QueryStringAttribute;
import io.undertow.attribute.RelativePathAttribute;
import io.undertow.attribute.RemoteHostAttribute;
import io.undertow.attribute.RemoteIPAttribute;
import io.undertow.attribute.RemoteObfuscatedIPAttribute;
import io.undertow.attribute.RemoteUserAttribute;
import io.undertow.attribute.RequestHeaderAttribute;
import io.undertow.attribute.RequestLineAttribute;
import io.undertow.attribute.RequestMethodAttribute;
import io.undertow.attribute.RequestPathAttribute;
import io.undertow.attribute.RequestProtocolAttribute;
import io.undertow.attribute.RequestSchemeAttribute;
import io.undertow.attribute.RequestURLAttribute;
import io.undertow.attribute.ResolvedPathAttribute;
import io.undertow.attribute.ResponseCodeAttribute;
import io.undertow.attribute.ResponseHeaderAttribute;
import io.undertow.attribute.ResponseReasonPhraseAttribute;
import io.undertow.attribute.ResponseTimeAttribute;
import io.undertow.attribute.SecureExchangeAttribute;
import io.undertow.attribute.SslCipherAttribute;
import io.undertow.attribute.SslClientCertAttribute;
import io.undertow.attribute.SslSessionIdAttribute;
import io.undertow.attribute.StoredResponse;
import io.undertow.attribute.ThreadNameAttribute;
import io.undertow.attribute.TransportProtocolAttribute;
import io.undertow.util.HttpString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.extension.undertow.AccessLogAttribute;
import org.wildfly.extension.undertow.logging.UndertowLogger;

class ExchangeAttributeDefinitions {
    private static final String KEY_NAME = "key";
    private static final SimpleAttributeDefinitionBuilder KEY_BUILDER = SimpleAttributeDefinitionBuilder.create((String)"key", (ModelType)ModelType.STRING, (boolean)true);
    private static final Map<AttributeDefinition, ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>> ATTRIBUTE_RESOLVERS = new HashMap<AttributeDefinition, ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>>();
    private static final SimpleAttributeDefinitionBuilder KEY_PREFIX_BUILDER = SimpleAttributeDefinitionBuilder.create((String)"key-prefix", (ModelType)ModelType.STRING, (boolean)true);
    private static final StringListAttributeDefinition NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)StringListAttributeDefinition.Builder.of((String)"names").setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshaller.AttributeElementMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            assert (attribute instanceof StringListAttributeDefinition);
            try {
                List list = ((StringListAttributeDefinition)attribute).unwrap(ExpressionResolver.SIMPLE, resourceModel);
                if (list.isEmpty()) {
                    return;
                }
                if (resourceModel.hasDefined(attribute.getName())) {
                    for (ModelNode value : resourceModel.get(attribute.getName()).asList()) {
                        writer.writeStartElement(attribute.getXmlName());
                        writer.writeAttribute("value", value.asString());
                        writer.writeEndElement();
                    }
                }
            }
            catch (OperationFailedException e) {
                throw new XMLStreamException(e);
            }
        }
    })).setAttributeParser(new AttributeParser(){

        public boolean isParseAsElement() {
            return true;
        }

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"value");
            String value = reader.getAttributeValue(0);
            operation.get(attribute.getName()).add(value);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }
    })).setRequired(true)).setXmlName("name")).build();
    private static final SimpleAttributeDefinition AUTHENTICATION_TYPE_KEY = ExchangeAttributeDefinitions.createKey("authenticationType");
    private static final ObjectTypeAttributeDefinition AUTHENTICATION_TYPE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"authentication-type", (AttributeDefinition[])new AttributeDefinition[]{AUTHENTICATION_TYPE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)AUTHENTICATION_TYPE_KEY, context, model, AuthenticationTypeExchangeAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition BYTES_SENT_KEY = ExchangeAttributeDefinitions.createKey("bytesSent");
    private static final ObjectTypeAttributeDefinition BYTES_SENT = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"bytes-sent", (AttributeDefinition[])new AttributeDefinition[]{BYTES_SENT_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)BYTES_SENT_KEY, context, model, (ExchangeAttribute)new BytesSentAttribute(false), new Function<String, Object>(){

                @Override
                public Object apply(String s) {
                    return Long.valueOf(s);
                }
            });
        }
    });
    private static final SimpleAttributeDefinition DATE_TIME_KEY = ExchangeAttributeDefinitions.createKey("dateTime");
    private static final SimpleAttributeDefinition DATE_FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"date-format", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            try {
                new SimpleDateFormat(value.asString());
            }
            catch (IllegalArgumentException ignore) {
                throw UndertowLogger.ROOT_LOGGER.invalidDateTimeFormatterPattern(value.asString());
            }
        }
    })).build();
    private static final SimpleAttributeDefinition TIME_ZONE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"time-zone", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, true){
        private final List<String> zoneIds = Arrays.asList(TimeZone.getAvailableIDs());

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            if (!this.zoneIds.contains(value.asString())) {
                throw UndertowLogger.ROOT_LOGGER.invalidTimeZoneId(value.asString());
            }
        }
    })).build();
    private static final ObjectTypeAttributeDefinition DATE_TIME = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"date-time", (AttributeDefinition[])new AttributeDefinition[]{DATE_TIME_KEY, DATE_FORMAT, TIME_ZONE}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ExchangeAttribute exchangeAttribute;
            if (model.hasDefined(DATE_FORMAT.getName())) {
                String timeZone = null;
                if (model.hasDefined(TIME_ZONE.getName())) {
                    timeZone = TIME_ZONE.resolveModelAttribute(context, model).asString();
                }
                exchangeAttribute = new DateTimeAttribute(DATE_FORMAT.resolveModelAttribute(context, model).asString(), timeZone);
            } else {
                exchangeAttribute = DateTimeAttribute.INSTANCE;
            }
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)DATE_TIME_KEY, context, model, exchangeAttribute);
        }
    });
    private static final SimpleAttributeDefinition HOST_AND_PORT_KEY = ExchangeAttributeDefinitions.createKey("hostAndPort");
    private static final ObjectTypeAttributeDefinition HOST_AND_PORT = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"host-and-port", (AttributeDefinition[])new AttributeDefinition[]{HOST_AND_PORT_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)HOST_AND_PORT_KEY, context, model, HostAndPortAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition LOCAL_IP_KEY = ExchangeAttributeDefinitions.createKey("localIp");
    private static final ObjectTypeAttributeDefinition LOCAL_IP = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"local-ip", (AttributeDefinition[])new AttributeDefinition[]{LOCAL_IP_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)LOCAL_IP_KEY, context, model, LocalIPAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition LOCAL_PORT_KEY = ExchangeAttributeDefinitions.createKey("localPort");
    private static final ObjectTypeAttributeDefinition LOCAL_PORT = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"local-port", (AttributeDefinition[])new AttributeDefinition[]{LOCAL_PORT_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)LOCAL_PORT_KEY, context, model, LocalPortAttribute.INSTANCE, new Function<String, Object>(){

                @Override
                public Object apply(String s) {
                    return Integer.valueOf(s);
                }
            });
        }
    });
    private static final SimpleAttributeDefinition LOCAL_SERVER_NAME_KEY = ExchangeAttributeDefinitions.createKey("localServerName");
    private static final ObjectTypeAttributeDefinition LOCAL_SERVER_NAME = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"local-server-name", (AttributeDefinition[])new AttributeDefinition[]{LOCAL_SERVER_NAME_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)LOCAL_SERVER_NAME_KEY, context, model, LocalServerNameAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition PATH_PARAMETER_KEY_PREFIX = KEY_PREFIX_BUILDER.build();
    private static final ObjectTypeAttributeDefinition PATH_PARAMETER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.Builder.of((String)"path-parameter", (AttributeDefinition[])new AttributeDefinition[]{PATH_PARAMETER_KEY_PREFIX, NAMES}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> result = new ArrayList<AccessLogAttribute>(5);
            for (ModelNode m : NAMES.resolveModelAttribute(context, model).asList()) {
                String name = m.asString();
                String keyName = ExchangeAttributeDefinitions.resolveKeyName(PATH_PARAMETER_KEY_PREFIX.resolveModelAttribute(context, model), name);
                result.add(AccessLogAttribute.of(keyName, (ExchangeAttribute)new PathParameterAttribute(name)));
            }
            return result;
        }
    });
    private static final SimpleAttributeDefinition PREDICATE_KEY_PREFIX = KEY_PREFIX_BUILDER.build();
    private static final ObjectTypeAttributeDefinition PREDICATE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.Builder.of((String)"predicate", (AttributeDefinition[])new AttributeDefinition[]{PREDICATE_KEY_PREFIX, NAMES}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> result = new ArrayList<AccessLogAttribute>(5);
            for (ModelNode m : NAMES.resolveModelAttribute(context, model).asList()) {
                String predicateName = m.asString();
                String keyName = ExchangeAttributeDefinitions.resolveKeyName(PREDICATE_KEY_PREFIX.resolveModelAttribute(context, model), predicateName);
                result.add(AccessLogAttribute.of(keyName, (ExchangeAttribute)new PredicateContextAttribute(predicateName)));
            }
            return result;
        }
    });
    private static final SimpleAttributeDefinition QUERY_PARAMETER_KEY_PREFIX = KEY_PREFIX_BUILDER.build();
    private static final ObjectTypeAttributeDefinition QUERY_PARAMETER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.Builder.of((String)"query-parameter", (AttributeDefinition[])new AttributeDefinition[]{QUERY_PARAMETER_KEY_PREFIX, NAMES}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> result = new ArrayList<AccessLogAttribute>(5);
            for (ModelNode m : NAMES.resolveModelAttribute(context, model).asList()) {
                String paramName = m.asString();
                String keyName = ExchangeAttributeDefinitions.resolveKeyName(QUERY_PARAMETER_KEY_PREFIX.resolveModelAttribute(context, model), paramName);
                result.add(AccessLogAttribute.of(keyName, (ExchangeAttribute)new QueryParameterAttribute(paramName)));
            }
            return result;
        }
    });
    private static final SimpleAttributeDefinition QUERY_STRING_KEY = ExchangeAttributeDefinitions.createKey("queryString");
    private static final SimpleAttributeDefinition INCLUDE_QUESTION_MARK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"include-question-mark", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    private static final ObjectTypeAttributeDefinition QUERY_STRING = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"query-string", (AttributeDefinition[])new AttributeDefinition[]{QUERY_STRING_KEY, INCLUDE_QUESTION_MARK}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            if (INCLUDE_QUESTION_MARK.resolveModelAttribute(context, model).asBoolean()) {
                return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)QUERY_STRING_KEY, context, model, QueryStringAttribute.INSTANCE);
            }
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)QUERY_STRING_KEY, context, model, QueryStringAttribute.BARE_INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition RELATIVE_PATH_KEY = ExchangeAttributeDefinitions.createKey("relativePath");
    private static final ObjectTypeAttributeDefinition RELATIVE_PATH = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"relative-path", (AttributeDefinition[])new AttributeDefinition[]{RELATIVE_PATH_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)RELATIVE_PATH_KEY, context, model, RelativePathAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REMOTE_HOST_KEY = ExchangeAttributeDefinitions.createKey("remoteHost");
    private static final ObjectTypeAttributeDefinition REMOTE_HOST = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"remote-host", (AttributeDefinition[])new AttributeDefinition[]{REMOTE_HOST_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REMOTE_HOST_KEY, context, model, RemoteHostAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REMOTE_IP_KEY = ExchangeAttributeDefinitions.createKey("remoteIp");
    private static final SimpleAttributeDefinition OBFUSCATED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"obfuscated", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    private static final ObjectTypeAttributeDefinition REMOTE_IP = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"remote-ip", (AttributeDefinition[])new AttributeDefinition[]{REMOTE_IP_KEY, OBFUSCATED}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            if (OBFUSCATED.resolveModelAttribute(context, model).asBoolean()) {
                return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REMOTE_IP_KEY, context, model, RemoteObfuscatedIPAttribute.INSTANCE);
            }
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REMOTE_IP_KEY, context, model, RemoteIPAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REMOTE_USER_KEY = ExchangeAttributeDefinitions.createKey("remoteUser");
    private static final ObjectTypeAttributeDefinition REMOTE_USER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"remote-user", (AttributeDefinition[])new AttributeDefinition[]{REMOTE_USER_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REMOTE_USER_KEY, context, model, RemoteUserAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_HEADER_KEY_PREFIX = KEY_PREFIX_BUILDER.build();
    private static final ObjectTypeAttributeDefinition REQUEST_HEADER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.Builder.of((String)"request-header", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_HEADER_KEY_PREFIX, NAMES}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> result = new ArrayList<AccessLogAttribute>(5);
            for (ModelNode m : NAMES.resolveModelAttribute(context, model).asList()) {
                String name = m.asString();
                String keyName = ExchangeAttributeDefinitions.resolveKeyName(REQUEST_HEADER_KEY_PREFIX.resolveModelAttribute(context, model), name);
                result.add(AccessLogAttribute.of(keyName, (ExchangeAttribute)new RequestHeaderAttribute(HttpString.tryFromString((String)name))));
            }
            return result;
        }
    });
    private static final SimpleAttributeDefinition REQUEST_LINE_KEY = ExchangeAttributeDefinitions.createKey("requestLine");
    private static final ObjectTypeAttributeDefinition REQUEST_LINE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-line", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_LINE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_LINE_KEY, context, model, RequestLineAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_METHOD_KEY = ExchangeAttributeDefinitions.createKey("requestMethod");
    private static final ObjectTypeAttributeDefinition REQUEST_METHOD = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-method", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_METHOD_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_METHOD_KEY, context, model, RequestMethodAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_PATH_KEY = ExchangeAttributeDefinitions.createKey("requestPath");
    private static final ObjectTypeAttributeDefinition REQUEST_PATH = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-path", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_PATH_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_PATH_KEY, context, model, RequestPathAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_PROTOCOL_KEY = ExchangeAttributeDefinitions.createKey("requestProtocol");
    private static final ObjectTypeAttributeDefinition REQUEST_PROTOCOL = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-protocol", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_PROTOCOL_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_PROTOCOL_KEY, context, model, RequestProtocolAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_SCHEME_KEY = ExchangeAttributeDefinitions.createKey("requestScheme");
    private static final ObjectTypeAttributeDefinition REQUEST_SCHEME = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-scheme", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_SCHEME_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_SCHEME_KEY, context, model, RequestSchemeAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition REQUEST_URL_KEY = ExchangeAttributeDefinitions.createKey("requestUrl");
    private static final ObjectTypeAttributeDefinition REQUEST_URL = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"request-url", (AttributeDefinition[])new AttributeDefinition[]{REQUEST_URL_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)REQUEST_URL_KEY, context, model, RequestURLAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition RESOLVED_PATH_KEY = ExchangeAttributeDefinitions.createKey("resolvedPath");
    private static final ObjectTypeAttributeDefinition RESOLVED_PATH = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"resolved-path", (AttributeDefinition[])new AttributeDefinition[]{RESOLVED_PATH_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)RESOLVED_PATH_KEY, context, model, ResolvedPathAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition RESPONSE_CODE_KEY = ExchangeAttributeDefinitions.createKey("responseCode");
    private static final ObjectTypeAttributeDefinition RESPONSE_CODE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"response-code", (AttributeDefinition[])new AttributeDefinition[]{RESPONSE_CODE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)RESPONSE_CODE_KEY, context, model, ResponseCodeAttribute.INSTANCE, new Function<String, Object>(){

                @Override
                public Object apply(String s) {
                    return Integer.valueOf(s);
                }
            });
        }
    });
    private static final SimpleAttributeDefinition RESPONSE_HEADER_KEY_PREFIX = KEY_PREFIX_BUILDER.build();
    private static final ObjectTypeAttributeDefinition RESPONSE_HEADER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.Builder.of((String)"response-header", (AttributeDefinition[])new AttributeDefinition[]{RESPONSE_HEADER_KEY_PREFIX, NAMES}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            ArrayList<AccessLogAttribute> result = new ArrayList<AccessLogAttribute>(5);
            for (ModelNode m : NAMES.resolveModelAttribute(context, model).asList()) {
                String name = m.asString();
                String keyName = ExchangeAttributeDefinitions.resolveKeyName(RESPONSE_HEADER_KEY_PREFIX.resolveModelAttribute(context, model), name);
                result.add(AccessLogAttribute.of(keyName, (ExchangeAttribute)new ResponseHeaderAttribute(HttpString.tryFromString((String)name))));
            }
            return result;
        }
    });
    private static final SimpleAttributeDefinition RESPONSE_REASON_PHRASE_KEY = ExchangeAttributeDefinitions.createKey("responseReasonPhrase");
    private static final ObjectTypeAttributeDefinition RESPONSE_REASON_PHRASE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"response-reason-phrase", (AttributeDefinition[])new AttributeDefinition[]{RESPONSE_REASON_PHRASE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)RESPONSE_REASON_PHRASE_KEY, context, model, ResponseReasonPhraseAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition RESPONSE_TIME_KEY = ExchangeAttributeDefinitions.createKey("responseTime");
    private static final SimpleAttributeDefinition TIME_UNIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("time-unit", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode(TimeUnit.MILLISECONDS.name()))).setValidator((ParameterValidator)EnumValidator.create(TimeUnit.class, (Enum[])new TimeUnit[]{TimeUnit.SECONDS, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS}))).build();
    private static final ObjectTypeAttributeDefinition RESPONSE_TIME = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"response-time", (AttributeDefinition[])new AttributeDefinition[]{RESPONSE_TIME_KEY, TIME_UNIT}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)RESPONSE_TIME_KEY, context, model, (ExchangeAttribute)new ResponseTimeAttribute(TimeUnit.valueOf(TIME_UNIT.resolveModelAttribute(context, model).asString())), new Function<String, Object>(){

                @Override
                public Object apply(String s) {
                    if (s == null) {
                        return null;
                    }
                    return Long.valueOf(s);
                }
            });
        }
    });
    private static final SimpleAttributeDefinition SECURE_EXCHANGE_KEY = ExchangeAttributeDefinitions.createKey("secureExchange");
    private static final ObjectTypeAttributeDefinition SECURE_EXCHANGE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"secure-exchange", (AttributeDefinition[])new AttributeDefinition[]{SECURE_EXCHANGE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)SECURE_EXCHANGE_KEY, context, model, SecureExchangeAttribute.INSTANCE, new Function<String, Object>(){

                @Override
                public Object apply(String s) {
                    return Boolean.valueOf(s);
                }
            });
        }
    });
    private static final SimpleAttributeDefinition SSL_CIPHER_KEY = ExchangeAttributeDefinitions.createKey("sslCipher");
    private static final ObjectTypeAttributeDefinition SSL_CIPHER = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"ssl-cipher", (AttributeDefinition[])new AttributeDefinition[]{SSL_CIPHER_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)SSL_CIPHER_KEY, context, model, (ExchangeAttribute)SslCipherAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition SSL_CLIENT_CERT_KEY = ExchangeAttributeDefinitions.createKey("sslClientCert");
    private static final ObjectTypeAttributeDefinition SSL_CLIENT_CERT = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"ssl-client-cert", (AttributeDefinition[])new AttributeDefinition[]{SSL_CLIENT_CERT_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)SSL_CLIENT_CERT_KEY, context, model, (ExchangeAttribute)SslClientCertAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition SSL_SESSION_ID_KEY = ExchangeAttributeDefinitions.createKey("sslSessionId");
    private static final ObjectTypeAttributeDefinition SSL_SESSION_ID = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"ssl-session-id", (AttributeDefinition[])new AttributeDefinition[]{SSL_SESSION_ID_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)SSL_SESSION_ID_KEY, context, model, (ExchangeAttribute)SslSessionIdAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition STORED_RESPONSE_KEY = ExchangeAttributeDefinitions.createKey("storedResponse");
    private static final ObjectTypeAttributeDefinition STORED_RESPONSE = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"stored-response", (AttributeDefinition[])new AttributeDefinition[]{STORED_RESPONSE_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)STORED_RESPONSE_KEY, context, model, StoredResponse.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition THREAD_NAME_KEY = ExchangeAttributeDefinitions.createKey("threadName");
    private static final ObjectTypeAttributeDefinition THREAD_NAME = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"thread-name", (AttributeDefinition[])new AttributeDefinition[]{THREAD_NAME_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)THREAD_NAME_KEY, context, model, ThreadNameAttribute.INSTANCE);
        }
    });
    private static final SimpleAttributeDefinition TRANSPORT_PROTOCOL_KEY = ExchangeAttributeDefinitions.createKey("transportProtocol");
    private static final ObjectTypeAttributeDefinition TRANSPORT_PROTOCOL = (ObjectTypeAttributeDefinition)ExchangeAttributeDefinitions.create(ObjectTypeAttributeDefinition.create((String)"transport-protocol", (AttributeDefinition[])new AttributeDefinition[]{TRANSPORT_PROTOCOL_KEY}), new ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException>(){

        public Collection<AccessLogAttribute> apply(OperationContext context, ModelNode model) throws OperationFailedException {
            return ExchangeAttributeDefinitions.createSingleton((AttributeDefinition)TRANSPORT_PROTOCOL_KEY, context, model, TransportProtocolAttribute.INSTANCE);
        }
    });
    static final ObjectTypeAttributeDefinition ATTRIBUTES = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.create((String)"attributes", (AttributeDefinition[])new AttributeDefinition[]{AUTHENTICATION_TYPE, BYTES_SENT, DATE_TIME, HOST_AND_PORT, LOCAL_IP, LOCAL_PORT, LOCAL_SERVER_NAME, PATH_PARAMETER, PREDICATE, QUERY_PARAMETER, QUERY_STRING, RELATIVE_PATH, REMOTE_HOST, REMOTE_IP, REMOTE_USER, REQUEST_HEADER, REQUEST_LINE, REQUEST_METHOD, REQUEST_PATH, REQUEST_PROTOCOL, REQUEST_SCHEME, REQUEST_URL, RESOLVED_PATH, RESPONSE_CODE, RESPONSE_HEADER, RESPONSE_REASON_PHRASE, RESPONSE_TIME, SECURE_EXCHANGE, SSL_CIPHER, SSL_CLIENT_CERT, SSL_SESSION_ID, STORED_RESPONSE, THREAD_NAME, TRANSPORT_PROTOCOL}).setDefaultValue(ExchangeAttributeDefinitions.createDefaultAttribute())).setRestartAllServices()).build();

    ExchangeAttributeDefinitions() {
    }

    static Collection<AccessLogAttribute> resolveAccessLogAttribute(AttributeDefinition attribute, OperationContext context, ModelNode model) throws OperationFailedException {
        ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException> attributeResolver = ATTRIBUTE_RESOLVERS.get(attribute);
        assert (attributeResolver != null);
        if (model.hasDefined(attribute.getName())) {
            return (Collection)attributeResolver.apply((Object)context, (Object)model.get(attribute.getName()));
        }
        return Collections.emptyList();
    }

    private static Collection<AccessLogAttribute> createSingleton(AttributeDefinition keyAttribute, OperationContext context, ModelNode model, ExchangeAttribute exchangeAttribute) throws OperationFailedException {
        return Collections.singletonList(AccessLogAttribute.of(keyAttribute.resolveModelAttribute(context, model).asString(), exchangeAttribute));
    }

    private static Collection<AccessLogAttribute> createSingleton(AttributeDefinition keyAttribute, OperationContext context, ModelNode model, ExchangeAttribute exchangeAttribute, Function<String, Object> valueConverter) throws OperationFailedException {
        return Collections.singletonList(AccessLogAttribute.of(keyAttribute.resolveModelAttribute(context, model).asString(), exchangeAttribute, valueConverter));
    }

    private static SimpleAttributeDefinition createKey(String dftValue) {
        return ((SimpleAttributeDefinitionBuilder)KEY_BUILDER.setDefaultValue(new ModelNode(dftValue))).build();
    }

    private static ModelNode createDefaultAttribute() {
        ModelNode result = new ModelNode().setEmptyObject();
        result.get(REMOTE_HOST.getName()).setEmptyObject();
        result.get(REMOTE_USER.getName()).setEmptyObject();
        result.get(DATE_TIME.getName()).setEmptyObject();
        result.get(REQUEST_LINE.getName()).setEmptyObject();
        result.get(RESPONSE_CODE.getName()).setEmptyObject();
        result.get(BYTES_SENT.getName()).setEmptyObject();
        return result;
    }

    private static <R extends AttributeDefinition, B extends AbstractAttributeDefinitionBuilder<B, R>> R create(B builder, ExceptionBiFunction<OperationContext, ModelNode, Collection<AccessLogAttribute>, OperationFailedException> attributeResolver) {
        AttributeDefinition result = builder.setRequired(false).build();
        ATTRIBUTE_RESOLVERS.put(result, attributeResolver);
        return (R)result;
    }

    private static String resolveKeyName(ModelNode prefix, String name) {
        StringBuilder result = new StringBuilder();
        if (prefix.isDefined()) {
            result.append(prefix.asString());
        }
        result.append(name);
        return result.toString();
    }
}

