/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class EJBSecurityMetaData {
    private final String securityDomain;
    private final String runAsRole;
    private final Set<String> declaredRoles;
    private final String runAsPrincipal;
    private final SecurityRolesMetaData securityRoles;
    private final Map<String, Collection<String>> securityRoleLinks;

    public EJBSecurityMetaData(ComponentConfiguration componentConfiguration) {
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbLogger.ROOT_LOGGER.invalidComponentConfiguration(componentConfiguration.getComponentName());
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.runAsRole = ejbComponentDescription.getRunAs();
        this.securityDomain = ejbComponentDescription.getSecurityDomain();
        this.runAsPrincipal = ejbComponentDescription.getRunAsPrincipal();
        this.securityRoles = ejbComponentDescription.getSecurityRoles();
        Map<String, Collection<String>> links = ejbComponentDescription.getSecurityRoleLinks();
        this.securityRoleLinks = links == null ? Collections.emptyMap() : Collections.unmodifiableMap(links);
        Set<String> roles = ejbComponentDescription.getDeclaredRoles();
        this.declaredRoles = roles == null ? Collections.emptySet() : Collections.unmodifiableSet(roles);
    }

    public Set<String> getDeclaredRoles() {
        return this.declaredRoles;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getRunAsPrincipal() {
        return this.runAsPrincipal;
    }

    public SecurityRolesMetaData getSecurityRoles() {
        return this.securityRoles;
    }

    public Map<String, Collection<String>> getSecurityRoleLinks() {
        return this.securityRoleLinks;
    }
}

