/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.RemoveListener;

public class DistributableCache<K, V extends Identifiable<K> & Contextual<Batch>>
implements Cache<K, V> {
    private final BeanManager<K, V, Batch> manager;
    private final StatefulObjectFactory<V> factory;
    private final TransactionSynchronizationRegistry tsr;
    private final RemoveListener<V> listener;

    public DistributableCache(BeanManager<K, V, Batch> manager, StatefulObjectFactory<V> factory, TransactionSynchronizationRegistry tsr) {
        this.manager = manager;
        this.factory = factory;
        this.tsr = tsr;
        this.listener = new RemoveListenerAdapter(factory);
    }

    public Affinity getStrictAffinity() {
        return this.manager.getStrictAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    public K createIdentifier() {
        Object id = this.manager.getIdentifierFactory().createIdentifier();
        Object group = CURRENT_GROUP.get();
        if (group == null) {
            group = id;
            CURRENT_GROUP.set(group);
        }
        return (K)id;
    }

    /*
     * Loose catch block
     */
    @Override
    public V create() {
        boolean newGroup = CURRENT_GROUP.get() == null;
        try {
            Identifiable identifiable;
            Throwable throwable = null;
            try (Batch batch = this.manager.getBatcher().createBatch();){
                Identifiable instance = (Identifiable)this.factory.createInstance();
                Object id = instance.getId();
                this.manager.createBean(id, CURRENT_GROUP.get(), (Object)instance).close();
                identifiable = instance;
            }
            catch (Error | RuntimeException e) {
                try {
                    batch.discard();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return (V)identifiable;
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            if (newGroup) {
                CURRENT_GROUP.remove();
            }
        }
    }

    @Override
    public V get(K id) {
        Batcher batcher = this.manager.getBatcher();
        boolean transactional = this.tsr.getTransactionKey() != null;
        Batch existingBatch = transactional ? (Batch)this.tsr.getResource(Batch.class) : null;
        Throwable throwable = null;
        try (BatchContext context = existingBatch != null ? batcher.resumeBatch(existingBatch) : null;){
            Bean bean;
            Batch batch;
            block19: {
                V v;
                batch = batcher.createBatch();
                try {
                    bean = this.manager.findBean(id);
                    if (bean != null) break block19;
                    batch.close();
                    v = null;
                }
                catch (Error | RuntimeException e) {
                    try {
                        batch.discard();
                        batch.close();
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return v;
            }
            Identifiable result = (Identifiable)bean.acquire();
            ((Contextual)((Object)result)).setCacheContext(batch);
            if (transactional && existingBatch == null) {
                this.tsr.putResource(Batch.class, (Object)batch);
            }
            Identifiable identifiable = result;
            return (V)identifiable;
        }
    }

    @Override
    public void release(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            try {
                Bean bean = this.manager.findBean(value.getId());
                if (bean != null && bean.release()) {
                    bean.close();
                }
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public void remove(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            try {
                Bean bean = this.manager.findBean(id);
                if (bean != null) {
                    bean.remove(this.listener);
                }
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public void discard(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            try {
                Bean bean = this.manager.findBean(value.getId());
                if (bean != null) {
                    bean.remove(null);
                }
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public boolean contains(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.containsBean(id);
            return bl;
        }
    }

    @Override
    public void start() {
        this.manager.start();
    }

    @Override
    public void stop() {
        this.manager.stop();
    }

    @Override
    public int getCacheSize() {
        return this.manager.getActiveCount();
    }

    @Override
    public int getPassivatedCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public int getTotalSize() {
        return this.manager.getActiveCount() + this.manager.getPassiveCount();
    }

    @Override
    public boolean isRemotable(Throwable throwable) {
        return this.manager.isRemotable(throwable);
    }
}

