/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractDelegatingInternalDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapLruNode;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionType;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SegmentedBoundedOffHeapDataContainer
extends AbstractDelegatingInternalDataContainer<WrappedBytes, WrappedBytes> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private final OffHeapMapSupplier offHeapMapSupplier;
    private final OffHeapListener offHeapListener;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    protected OffHeapMemoryAllocator allocator;
    @Inject
    protected OffHeapEntryFactory offHeapEntryFactory;
    @Inject
    protected EvictionManager evictionManager;
    @Inject
    protected ComponentRef<PassivationManager> passivator;
    protected final long maxSize;
    protected final Lock lruLock;
    protected final boolean useCount;
    protected long currentSize;
    protected long firstAddress;
    protected long lastAddress;
    protected DefaultSegmentedDataContainer dataContainer;

    public SegmentedBoundedOffHeapDataContainer(int addressCount, int numSegments, long maxSize, EvictionType type) {
        int sizePerSegment = addressCount / numSegments;
        this.offHeapListener = new OffHeapListener();
        this.maxSize = maxSize;
        this.useCount = type == EvictionType.COUNT;
        this.offHeapMapSupplier = this.useCount ? new OffHeapMapSupplier(false, sizePerSegment) : new OffHeapMapSupplier(true, sizePerSegment);
        this.lruLock = new ReentrantLock();
        this.firstAddress = 0L;
        this.dataContainer = new DefaultSegmentedDataContainer<WrappedBytes, WrappedBytes>(this.offHeapMapSupplier, numSegments);
    }

    @Start
    public void start() {
        this.componentRegistry.wireDependencies(this.dataContainer);
        this.dataContainer.start();
    }

    @Stop(priority=999)
    public void stop() {
        this.dataContainer.stop();
    }

    @Override
    protected InternalDataContainer<WrappedBytes, WrappedBytes> delegate() {
        return this.dataContainer;
    }

    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        super.put(key, value, metadata);
        this.ensureSize();
    }

    @Override
    public void put(int segment, WrappedBytes wrappedBytes, WrappedBytes wrappedBytes2, Metadata metadata) {
        super.put(segment, wrappedBytes, wrappedBytes2, metadata);
        this.ensureSize();
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(int segment, WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(segment, key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    protected OffHeapConcurrentMap getMapThatContainsKey(byte[] key) {
        int segment = this.dataContainer.getSegmentForKey(key);
        return (OffHeapConcurrentMap)this.dataContainer.getMapForSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureSize() {
        while (true) {
            long addressToRemove;
            Lock entryWriteLock;
            OffHeapConcurrentMap map;
            byte[] key;
            this.lruLock.lock();
            try {
                if (this.currentSize <= this.maxSize) return;
                assert (this.firstAddress > 0L);
                key = this.offHeapEntryFactory.getKey(this.firstAddress);
                map = this.getMapThatContainsKey(key);
                if (map == null) continue;
                int hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress);
                entryWriteLock = map.getLocks().getLockFromHashCode(hashCode).writeLock();
                addressToRemove = entryWriteLock.tryLock() ? this.firstAddress : 0L;
            }
            finally {
                this.lruLock.unlock();
                continue;
            }
            if (addressToRemove == 0L) {
                entryWriteLock.lock();
                try {
                    this.lruLock.lock();
                    try {
                        if (this.currentSize <= this.maxSize) return;
                        key = this.offHeapEntryFactory.getKey(this.firstAddress);
                        OffHeapConcurrentMap protectedMap = this.getMapThatContainsKey(key);
                        if (protectedMap == map) {
                            int hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress);
                            Lock innerLock = map.getLocks().getLockFromHashCode(hashCode).writeLock();
                            if (innerLock == entryWriteLock) {
                                addressToRemove = this.firstAddress;
                            }
                        }
                    }
                    finally {
                        this.lruLock.unlock();
                    }
                }
                finally {
                    if (addressToRemove == 0L) {
                        entryWriteLock.unlock();
                    }
                }
            }
            if (addressToRemove == 0L) continue;
            if (trace) {
                log.tracef("Removing entry: 0x%016x due to eviction due to size %d being larger than maximum of %d", addressToRemove, this.currentSize, this.maxSize);
            }
            try {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(addressToRemove);
                this.passivator.running().passivate(ice);
                map.remove((WrappedBytes)ice.getKey(), addressToRemove);
                this.evictionManager.onEntryEviction(Collections.singletonMap(ice.getKey(), ice));
                continue;
            }
            finally {
                entryWriteLock.unlock();
                continue;
            }
            break;
        }
    }

    public long getSize(long address) {
        if (this.useCount) {
            return 1L;
        }
        return this.offHeapEntryFactory.getSize(address, true);
    }

    @Override
    public long capacity() {
        return this.maxSize;
    }

    @Override
    public long evictionSize() {
        return this.currentSize;
    }

    private class OffHeapListener
    implements OffHeapConcurrentMap.EntryListener {
        private OffHeapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryCreated(long newAddress) {
            long newSize = SegmentedBoundedOffHeapDataContainer.this.getSize(newAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                SegmentedBoundedOffHeapDataContainer.this.currentSize += newSize;
                this.addEntryAddressToEnd(newAddress);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryRemoved(long removedAddress) {
            long removedSize = SegmentedBoundedOffHeapDataContainer.this.getSize(removedAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                SegmentedBoundedOffHeapDataContainer.this.currentSize -= removedSize;
                this.removeNode(removedAddress);
                SegmentedBoundedOffHeapDataContainer.this.allocator.deallocate(removedAddress, SegmentedBoundedOffHeapDataContainer.this.offHeapEntryFactory.getSize(removedAddress, false));
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryReplaced(long newAddress, long oldAddress) {
            long oldSize = SegmentedBoundedOffHeapDataContainer.this.getSize(oldAddress);
            long newSize = SegmentedBoundedOffHeapDataContainer.this.getSize(newAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                this.removeNode(oldAddress);
                this.addEntryAddressToEnd(newAddress);
                SegmentedBoundedOffHeapDataContainer.this.currentSize += newSize;
                SegmentedBoundedOffHeapDataContainer.this.currentSize -= oldSize;
                SegmentedBoundedOffHeapDataContainer.this.allocator.deallocate(oldAddress, SegmentedBoundedOffHeapDataContainer.this.offHeapEntryFactory.getSize(oldAddress, false));
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        @Override
        public void entryRetrieved(long entryAddress) {
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                if (trace) {
                    log.tracef("Moving entry 0x%016x to the end of the LRU list", entryAddress);
                }
                this.moveToEnd(entryAddress);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        private void addEntryAddressToEnd(long entryAddress) {
            if (trace) {
                log.tracef("Adding entry 0x%016x to the end of the LRU list", entryAddress);
            }
            if (SegmentedBoundedOffHeapDataContainer.this.lastAddress == 0L) {
                SegmentedBoundedOffHeapDataContainer.this.firstAddress = entryAddress;
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = entryAddress;
                OffHeapLruNode.setPrevious(entryAddress, 0L);
            } else {
                OffHeapLruNode.setPrevious(entryAddress, SegmentedBoundedOffHeapDataContainer.this.lastAddress);
                OffHeapLruNode.setNext(SegmentedBoundedOffHeapDataContainer.this.lastAddress, entryAddress);
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = entryAddress;
            }
            OffHeapLruNode.setNext(entryAddress, 0L);
        }

        private void removeNode(long address) {
            long previousLRUNode;
            boolean middleNode = true;
            if (address == SegmentedBoundedOffHeapDataContainer.this.lastAddress) {
                if (trace) {
                    log.tracef("Removed entry 0x%016x from the end of the LRU list", address);
                }
                if ((previousLRUNode = OffHeapLruNode.getPrevious(address)) != 0L) {
                    OffHeapLruNode.setNext(previousLRUNode, 0L);
                }
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = previousLRUNode;
                middleNode = false;
            }
            if (address == SegmentedBoundedOffHeapDataContainer.this.firstAddress) {
                long nextLRUNode;
                if (trace) {
                    log.tracef("Removed entry 0x%016x from the beginning of the LRU list", address);
                }
                if ((nextLRUNode = OffHeapLruNode.getNext(address)) != 0L) {
                    OffHeapLruNode.setPrevious(nextLRUNode, 0L);
                }
                SegmentedBoundedOffHeapDataContainer.this.firstAddress = nextLRUNode;
                middleNode = false;
            }
            if (middleNode) {
                if (trace) {
                    log.tracef("Removed entry 0x%016x from the middle of the LRU list", address);
                }
                previousLRUNode = OffHeapLruNode.getPrevious(address);
                long nextLRUNode = OffHeapLruNode.getNext(address);
                assert (previousLRUNode != 0L);
                assert (nextLRUNode != 0L);
                OffHeapLruNode.setNext(previousLRUNode, nextLRUNode);
                OffHeapLruNode.setPrevious(nextLRUNode, previousLRUNode);
            }
        }

        private void moveToEnd(long lruNode) {
            if (lruNode != SegmentedBoundedOffHeapDataContainer.this.lastAddress) {
                long nextLruNode = OffHeapLruNode.getNext(lruNode);
                assert (nextLruNode != 0L);
                if (lruNode == SegmentedBoundedOffHeapDataContainer.this.firstAddress) {
                    OffHeapLruNode.setPrevious(nextLruNode, 0L);
                    SegmentedBoundedOffHeapDataContainer.this.firstAddress = nextLruNode;
                } else {
                    long prevLruNode = OffHeapLruNode.getPrevious(lruNode);
                    assert (prevLruNode != 0L);
                    OffHeapLruNode.setNext(prevLruNode, nextLruNode);
                    OffHeapLruNode.setPrevious(nextLruNode, prevLruNode);
                }
                OffHeapLruNode.setNext(SegmentedBoundedOffHeapDataContainer.this.lastAddress, lruNode);
                OffHeapLruNode.setPrevious(lruNode, SegmentedBoundedOffHeapDataContainer.this.lastAddress);
                OffHeapLruNode.setNext(lruNode, 0L);
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = lruNode;
            }
        }
    }

    private class OffHeapMapSupplier
    implements Supplier<ConcurrentMap<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>> {
        private final boolean addAllocationSize;
        private final int allocationSize;

        private OffHeapMapSupplier(boolean addAllocationSize, int allocationSize) {
            this.addAllocationSize = addAllocationSize;
            this.allocationSize = Util.findNextHighestPowerOfTwo((int)allocationSize);
        }

        @Override
        public ConcurrentMap<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>> get() {
            OffHeapConcurrentMap map = new OffHeapConcurrentMap(this.allocationSize, SegmentedBoundedOffHeapDataContainer.this.allocator, SegmentedBoundedOffHeapDataContainer.this.offHeapEntryFactory, SegmentedBoundedOffHeapDataContainer.this.offHeapListener){

                @Override
                public void stop() {
                    super.stop();
                    if (OffHeapMapSupplier.this.addAllocationSize) {
                        SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
                        try {
                            SegmentedBoundedOffHeapDataContainer.this.currentSize -= UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(OffHeapMapSupplier.this.allocationSize << 3);
                        }
                        finally {
                            SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
                        }
                    }
                }
            };
            if (this.addAllocationSize) {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
                try {
                    SegmentedBoundedOffHeapDataContainer.this.currentSize += UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(this.allocationSize << 3);
                }
                finally {
                    SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
                }
            }
            map.start();
            return map;
        }
    }
}

