/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetBuilder;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;

public class InjectionTargets {
    private InjectionTargets() {
    }

    public static <T> WeldInjectionTarget<T> createInjectionTarget(Class<?> componentClass, Bean<T> bean, BeanManagerImpl beanManager, boolean interceptionSupport) {
        Class<?> clazz;
        ClassTransformer transformer = (ClassTransformer)beanManager.getServices().get(ClassTransformer.class);
        EnhancedAnnotatedType type = transformer.getEnhancedAnnotatedType(clazz = componentClass, beanManager.getId());
        if (!type.getJavaClass().equals(componentClass)) {
            String bdaId = beanManager.getId() + componentClass.getClassLoader().hashCode();
            type = transformer.getEnhancedAnnotatedType(clazz, bdaId);
        }
        if (Beans.getBeanConstructor((EnhancedAnnotatedType)type) == null) {
            return beanManager.getInjectionTargetFactory((AnnotatedType)type).createNonProducibleInjectionTarget();
        }
        WeldInjectionTargetBuilder builder = beanManager.createInjectionTargetBuilder((AnnotatedType)type);
        builder.setBean(bean);
        builder.setResourceInjectionEnabled(false);
        if (interceptionSupport) {
            return builder.build();
        }
        return builder.setInterceptionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).setDecorationEnabled(false).build();
    }
}

