/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.EeExtension;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EESubsystemParser10
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    EESubsystemParser10() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode eeSubSystem = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{EeExtension.PATH_SUBSYSTEM}));
        list.add(eeSubSystem);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case EE_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case GLOBAL_MODULES: {
                            ModelNode model = EESubsystemParser10.parseGlobalModules(reader);
                            eeSubSystem.get("global-modules").set(model);
                            continue block7;
                        }
                        case EAR_SUBDEPLOYMENTS_ISOLATED: {
                            String earSubDeploymentsIsolated = EESubsystemParser10.parseEarSubDeploymentsIsolatedElement(reader);
                            EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.parseAndSetParameter(earSubDeploymentsIsolated, eeSubSystem, (XMLStreamReader)reader);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode parseGlobalModules(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode globalModules = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case MODULE: {
                    ModelNode module = new ModelNode();
                    int count = reader.getAttributeCount();
                    String name = null;
                    String slot = null;
                    block8: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                if (name != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                name = value;
                                GlobalModulesDefinition.NAME_AD.parseAndSetParameter(name, module, (XMLStreamReader)reader);
                                continue block8;
                            }
                            case SLOT: {
                                if (slot != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                slot = value;
                                GlobalModulesDefinition.SLOT_AD.parseAndSetParameter(slot, module, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
                    }
                    globalModules.add(module);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return globalModules;
    }

    static String parseEarSubDeploymentsIsolatedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        if (value == null || value.trim().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.invalidValue(value, Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName(), reader.getLocation());
        }
        return value.trim();
    }
}

