/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.singleton.DeferredInjector;
import org.wildfly.clustering.server.singleton.DistributedSingletonService;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceConfiguratorContext;
import org.wildfly.clustering.server.singleton.DistributedSingletonServiceContext;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.SimpleSingletonElectionPolicy;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceConfigurator;

public class DistributedSingletonServiceConfigurator
extends SimpleServiceNameProvider
implements SingletonServiceConfigurator,
DistributedSingletonServiceContext {
    private final SupplierDependency<ServiceProviderRegistry<ServiceName>> registry;
    private final SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile SingletonElectionPolicy electionPolicy = new SimpleSingletonElectionPolicy();
    private volatile int quorum = 1;

    public DistributedSingletonServiceConfigurator(DistributedSingletonServiceConfiguratorContext context, ServiceName name) {
        super(name);
        this.registry = context.getServiceProviderRegistryDependency();
        this.dispatcherFactory = context.getCommandDispatcherFactoryDependency();
    }

    public SingletonServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName().append(new String[]{"singleton"}));
        return new DistributedSingletonServiceBuilder(this, new CompositeDependency(new Dependency[]{this.registry, this.dispatcherFactory}).register(builder));
    }

    public SingletonServiceConfigurator requireQuorum(int quorum) {
        this.quorum = quorum;
        return this;
    }

    public SingletonServiceConfigurator electionPolicy(SingletonElectionPolicy policy) {
        this.electionPolicy = policy;
        return this;
    }

    @Override
    public Supplier<ServiceProviderRegistry<ServiceName>> getServiceProviderRegistry() {
        return this.registry;
    }

    @Override
    public Supplier<CommandDispatcherFactory> getCommandDispatcherFactory() {
        return this.dispatcherFactory;
    }

    @Override
    public SingletonElectionPolicy getElectionPolicy() {
        return this.electionPolicy;
    }

    @Override
    public int getQuorum() {
        return this.quorum;
    }

    private static class DistributedSingletonServiceBuilder<T>
    extends DelegatingServiceBuilder<T>
    implements SingletonServiceBuilder<T> {
        private final DistributedSingletonServiceContext context;
        private final List<Map.Entry<ServiceName[], DeferredInjector<?>>> injectors = new LinkedList();
        private Service service = Service.NULL;

        DistributedSingletonServiceBuilder(DistributedSingletonServiceContext context, ServiceBuilder<T> builder) {
            super(builder);
            this.context = context;
        }

        public <V> Consumer<V> provides(ServiceName ... names) {
            DeferredInjector injector = new DeferredInjector();
            this.injectors.add(new AbstractMap.SimpleImmutableEntry(names, injector));
            return injector;
        }

        public ServiceBuilder<T> setInstance(Service service) {
            this.service = service;
            return this;
        }

        public ServiceController<T> install() {
            return this.getDelegate().setInstance((Service)new DistributedSingletonService(this.context, this.service, this.injectors)).install();
        }
    }
}

