/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.PathValueOperation;

public final class ReplaceOperation
extends PathValueOperation {
    @JsonCreator
    public ReplaceOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (((JsonNode)this.path.path((TreeNode)node)).isMissingNode()) {
            throw new JsonPatchException("no such path in target JSON document");
        }
        JsonNode replacement = this.value.deepCopy();
        if (this.path.isEmpty()) {
            return replacement;
        }
        JsonPatchOperation.SplitPointer split = new JsonPatchOperation.SplitPointer(this.path);
        JsonNode ret = node.deepCopy();
        JsonNode parent = (JsonNode)split.parent.get((TreeNode)ret);
        String rawToken = split.lastToken.getToken().getRaw();
        if (parent.isObject()) {
            ((ObjectNode)parent).put(rawToken, replacement);
        } else {
            ((ArrayNode)parent).set(Integer.parseInt(rawToken), replacement);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "replace: " + super.toString();
    }
}

