/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class RouteRegistryEntryProviderBuilder
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<String, Map.Entry<String, Void>> {
    private final SupplierDependency<String> route;

    public RouteRegistryEntryProviderBuilder(String serverName, SupplierDependency<String> route) {
        super(ServiceName.parse((String)ClusteringCacheRequirement.REGISTRY_ENTRY.resolve("web", serverName)));
        this.route = route;
    }

    @Override
    public Map.Entry<String, Void> apply(String route) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(route, null);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer entry = this.route.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(entry, (Function)this, this.route);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

