/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;

final class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEGED.getProperty(name, defaultValue);
    }

    static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name);
        }
        return SysProps.PRIVILEGED.getProperty(name);
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    static Object invokeAccessibly(Object instance, Method method, Object[] parameters) {
        return SecurityActions.doPrivileged(() -> {
            try {
                method.setAccessible(true);
                return method.invoke(instance, parameters);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                throw new CacheException("Unable to invoke method " + method + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), cause);
            }
            catch (Exception e) {
                throw new CacheException("Unable to invoke method " + method + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e);
            }
        });
    }

    static ClassLoader[] getClassLoaders(ClassLoader appClassLoader) {
        return SecurityActions.doPrivileged(() -> new ClassLoader[]{appClassLoader, Util.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()});
    }

    private static ClassLoader getOSGiClassLoader() {
        try {
            Class<?> osgiClassLoader = Class.forName("org.infinispan.commons.util.OsgiClassLoader");
            return (ClassLoader)osgiClassLoader.getMethod("getInstance", null).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to call getInstance on OsgiClassLoader", e);
        }
    }

    static ClassLoader[] getOSGIContextClassLoaders(ClassLoader appClassLoader) {
        return SecurityActions.doPrivileged(() -> new ClassLoader[]{appClassLoader, SecurityActions.getOSGiClassLoader(), Util.class.getClassLoader(), ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()});
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return AccessController.doPrivileged(() -> System.getProperty(name, defaultValue));
            }

            @Override
            public String getProperty(String name) {
                return AccessController.doPrivileged(() -> System.getProperty(name));
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);
    }
}

